% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_cloud_watch_logging_option}
\alias{kinesisanalyticsv2_add_application_cloud_watch_logging_option}
\title{Adds an Amazon CloudWatch log stream to monitor application
configuration errors}
\usage{
kinesisanalyticsv2_add_application_cloud_watch_logging_option(
  ApplicationName,
  CurrentApplicationVersionId = NULL,
  CloudWatchLoggingOption,
  ConditionalToken = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The Kinesis Data Analytics application name.}

\item{CurrentApplicationVersionId}{The version ID of the SQL-based Kinesis Data Analytics application. You
must provide the \code{CurrentApplicationVersionId} or the
\code{ConditionalToken}.You can retrieve the application version ID using
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}. For
better concurrency support, use the \code{ConditionalToken} parameter instead
of \code{CurrentApplicationVersionId}.}

\item{CloudWatchLoggingOption}{[required] Provides the Amazon CloudWatch log stream Amazon Resource Name (ARN).}

\item{ConditionalToken}{A value you use to implement strong concurrency for application updates.
You must provide the \code{CurrentApplicationVersionId} or the
\code{ConditionalToken}. You get the application's current \code{ConditionalToken}
using \code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}.
For better concurrency support, use the \code{ConditionalToken} parameter
instead of \code{CurrentApplicationVersionId}.}
}
\description{
Adds an Amazon CloudWatch log stream to monitor application configuration errors.

See \url{https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_cloud_watch_logging_option/} for full documentation.
}
\keyword{internal}
