% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_register_domain}
\alias{swf_register_domain}
\title{Registers a new domain}
\usage{
swf_register_domain(name, description,
  workflowExecutionRetentionPeriodInDays, tags)
}
\arguments{
\item{name}{[required] Name of the domain to register. The name must be unique in the region
that the domain is registered in.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\code{U+0000`-`U+001f} \| \code{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{description}{A text description of the domain.}

\item{workflowExecutionRetentionPeriodInDays}{[required] The duration (in days) that records and histories of workflow executions
on the domain should be kept by the service. After the retention period,
the workflow execution isn't available in the results of visibility
calls.

If you pass the value \code{NONE} or \code{0} (zero), then the workflow execution
history isn't retained. As soon as the workflow execution completes,
the execution record and its history are deleted.

The maximum workflow execution retention period is 90 days. For more
information about Amazon SWF service limits, see: \href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html}{Amazon SWF Service Limits}
in the \emph{Amazon SWF Developer Guide}.}

\item{tags}{Tags to be added when registering a domain.

Tags may only contain unicode letters, digits, whitespace, or these
symbols: \code{_ . : / = + - @}.}
}
\description{
Registers a new domain.
}
\details{
\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item You cannot use an IAM policy to control domain access for this
action. The name of the domain being registered is available as the
resource of this action.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item You cannot use an IAM policy to constrain this action's parameters.
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$register_domain(
  name = "string",
  description = "string",
  workflowExecutionRetentionPeriodInDays = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
