% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_publish}
\alias{sns_publish}
\title{Sends a message to an Amazon SNS topic, a text message (SMS message)
directly to a phone number, or a message to a mobile platform endpoint
(when you specify the TargetArn)}
\usage{
sns_publish(TopicArn, TargetArn, PhoneNumber, Message, Subject,
  MessageStructure, MessageAttributes)
}
\arguments{
\item{TopicArn}{The topic you want to publish to.

If you don\'t specify a value for the \code{TopicArn} parameter, you must
specify a value for the \code{PhoneNumber} or \code{TargetArn} parameters.}

\item{TargetArn}{If you don\'t specify a value for the \code{TargetArn} parameter, you must
specify a value for the \code{PhoneNumber} or \code{TopicArn} parameters.}

\item{PhoneNumber}{The phone number to which you want to deliver an SMS message. Use E.164
format.

If you don\'t specify a value for the \code{PhoneNumber} parameter, you must
specify a value for the \code{TargetArn} or \code{TopicArn} parameters.}

\item{Message}{[required] The message you want to send.

If you are publishing to a topic and you want to send the same message
to all transport protocols, include the text of the message as a String
value. If you want to send different messages for each transport
protocol, set the value of the \code{MessageStructure} parameter to \code{json}
and use a JSON object for the \code{Message} parameter.

Constraints:
\itemize{
\item With the exception of SMS, messages must be UTF-8 encoded strings
and at most 256 KB in size (262,144 bytes, not 262,144 characters).
\item For SMS, each message can contain up to 140 characters. This
character limit depends on the encoding schema. For example, an SMS
message can contain 160 GSM characters, 140 ASCII characters, or 70
UCS-2 characters.

If you publish a message that exceeds this size limit, Amazon SNS
sends the message as multiple messages, each fitting within the size
limit. Messages aren\'t truncated mid-word but are cut off at
whole-word boundaries.

The total size limit for a single SMS \code{Publish} action is 1,600
characters.
}

JSON-specific constraints:
\itemize{
\item Keys in the JSON object that correspond to supported transport
protocols must have simple JSON string values.
\item The values will be parsed (unescaped) before they are used in
outgoing messages.
\item Outbound notifications are JSON encoded (meaning that the characters
will be reescaped for sending).
\item Values have a minimum length of 0 (the empty string, \"\", is
allowed).
\item Values have a maximum length bounded by the overall message size
(so, including multiple protocols may limit message sizes).
\item Non-string values will cause the key to be ignored.
\item Keys that do not correspond to supported transport protocols are
ignored.
\item Duplicate keys are not allowed.
\item Failure to parse or validate any key or value in the message will
cause the \code{Publish} call to return an error (no partial delivery).
}}

\item{Subject}{Optional parameter to be used as the \"Subject\" line when the message
is delivered to email endpoints. This field will also be included, if
present, in the standard JSON messages delivered to other endpoints.

Constraints: Subjects must be ASCII text that begins with a letter,
number, or punctuation mark; must not include line breaks or control
characters; and must be less than 100 characters long.}

\item{MessageStructure}{Set \code{MessageStructure} to \code{json} if you want to send a different message
for each protocol. For example, using one publish action, you can send a
short message to your SMS subscribers and a longer message to your email
subscribers. If you set \code{MessageStructure} to \code{json}, the value of the
\code{Message} parameter must:
\itemize{
\item be a syntactically valid JSON object; and
\item contain at least a top-level JSON key of \"default\" with a value
that is a string.
}

You can define other top-level keys that define the message you want to
send to a specific transport protocol (e.g., \"http\").

Valid value: \code{json}}

\item{MessageAttributes}{Message attributes for Publish action.}
}
\description{
Sends a message to an Amazon SNS topic, a text message (SMS message)
directly to a phone number, or a message to a mobile platform endpoint
(when you specify the \code{TargetArn}).
}
\details{
If you send a message to a topic, Amazon SNS delivers the message to
each endpoint that is subscribed to the topic. The format of the message
depends on the notification protocol for each subscribed endpoint.

When a \code{messageId} is returned, the message has been saved and Amazon
SNS will attempt to deliver it shortly.

To use the \code{Publish} action for sending a message to a mobile endpoint,
such as an app on a Kindle device or mobile phone, you must specify the
EndpointArn for the TargetArn parameter. The EndpointArn is returned
when making a call with the \code{CreatePlatformEndpoint} action.

For more information about formatting messages, see \href{https://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html}{Send Custom Platform-Specific Payloads in Messages to Mobile Devices}.

You can publish messages only to topics and endpoints in the same AWS
Region.
}
\section{Request syntax}{
\preformatted{svc$publish(
  TopicArn = "string",
  TargetArn = "string",
  PhoneNumber = "string",
  Message = "string",
  Subject = "string",
  MessageStructure = "string",
  MessageAttributes = list(
    list(
      DataType = "string",
      StringValue = "string",
      BinaryValue = raw
    )
  )
)
}
}

\keyword{internal}
