% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_reserved_instances_listing}
\alias{ec2_create_reserved_instances_listing}
\title{Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
in the Reserved Instance Marketplace}
\usage{
ec2_create_reserved_instances_listing(ClientToken, InstanceCount,
  PriceSchedules, ReservedInstancesId)
}
\arguments{
\item{ClientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
your listings. This helps avoid duplicate listings. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{InstanceCount}{[required] The number of instances that are a part of a Reserved Instance account
to be listed in the Reserved Instance Marketplace. This number should be
less than or equal to the instance count associated with the Reserved
Instance ID specified in this call.}

\item{PriceSchedules}{[required] A list specifying the price of the Standard Reserved Instance for each
month remaining in the Reserved Instance term.}

\item{ReservedInstancesId}{[required] The ID of the active Standard Reserved Instance.}
}
\description{
Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
in the Reserved Instance Marketplace. You can submit one Standard
Reserved Instance listing at a time. To get a list of your Standard
Reserved Instances, you can use the DescribeReservedInstances operation.

Only Standard Reserved Instances can be sold in the Reserved Instance
Marketplace. Convertible Reserved Instances cannot be sold.

The Reserved Instance Marketplace matches sellers who want to resell
Standard Reserved Instance capacity that they no longer need with buyers
who want to purchase additional capacity. Reserved Instances bought and
sold through the Reserved Instance Marketplace work like any other
Reserved Instances.

To sell your Standard Reserved Instances, you must first register as a
seller in the Reserved Instance Marketplace. After completing the
registration process, you can create a Reserved Instance Marketplace
listing of some or all of your Standard Reserved Instances, and specify
the upfront price to receive for them. Your Standard Reserved Instance
listings then become available for purchase. To view the details of your
Standard Reserved Instance listing, you can use the
DescribeReservedInstancesListings operation.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html}{Reserved Instance Marketplace}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_reserved_instances_listing(
  ClientToken = "string",
  InstanceCount = 123,
  PriceSchedules = list(
    list(
      CurrencyCode = "USD",
      Price = 123.0,
      Term = 123
    )
  ),
  ReservedInstancesId = "string"
)
}
}

\keyword{internal}
