% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_deregister_transit_gateway_multicast_group_members}
\alias{ec2_deregister_transit_gateway_multicast_group_members}
\title{Deregisters the specified members (network interfaces) from the transit
gateway multicast group}
\usage{
ec2_deregister_transit_gateway_multicast_group_members(
  TransitGatewayMulticastDomainId, GroupIpAddress, NetworkInterfaceIds,
  DryRun)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{The ID of the transit gateway multicast domain.}

\item{GroupIpAddress}{The IP address assigned to the transit gateway multicast group.}

\item{NetworkInterfaceIds}{The IDs of the group members' network interfaces.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deregisters the specified members (network interfaces) from the transit
gateway multicast group.
}
\section{Request syntax}{
\preformatted{svc$deregister_transit_gateway_multicast_group_members(
  TransitGatewayMulticastDomainId = "string",
  GroupIpAddress = "string",
  NetworkInterfaceIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
