% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_function_event_invoke_config}
\alias{lambda_get_function_event_invoke_config}
\title{Retrieves the configuration for asynchronous invocation for a function,
version, or alias}
\usage{
lambda_get_function_event_invoke_config(FunctionName, Qualifier)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{Qualifier}{A version number or alias name.}
}
\description{
Retrieves the configuration for asynchronous invocation for a function,
version, or alias.

To configure options for asynchronous invocation, use
PutFunctionEventInvokeConfig.
}
\section{Request syntax}{
\preformatted{svc$get_function_event_invoke_config(
  FunctionName = "string",
  Qualifier = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the asynchronous invocation configuration
# for the BLUE alias of a function named my-function.
svc$get_function_event_invoke_config(
  FunctionName = "my-function",
  Qualifier = "BLUE"
)
}

}
\keyword{internal}
