% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disassociate_transit_gateway_multicast_domain}
\alias{ec2_disassociate_transit_gateway_multicast_domain}
\title{Disassociates the specified subnets from the transit gateway multicast
domain}
\usage{
ec2_disassociate_transit_gateway_multicast_domain(
  TransitGatewayMulticastDomainId, TransitGatewayAttachmentId, SubnetIds,
  DryRun)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{The ID of the transit gateway multicast domain.}

\item{TransitGatewayAttachmentId}{The ID of the attachment.}

\item{SubnetIds}{The IDs of the subnets;}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Associations = list(
    TransitGatewayMulticastDomainId = "string",
    TransitGatewayAttachmentId = "string",
    ResourceId = "string",
    ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
    ResourceOwnerId = "string",
    Subnets = list(
      list(
        SubnetId = "string",
        State = "pendingAcceptance"|"associating"|"associated"|"disassociating"|"disassociated"|"rejected"|"failed"
      )
    )
  )
)
}
}
\description{
Disassociates the specified subnets from the transit gateway multicast
domain.
}
\section{Request syntax}{
\preformatted{svc$disassociate_transit_gateway_multicast_domain(
  TransitGatewayMulticastDomainId = "string",
  TransitGatewayAttachmentId = "string",
  SubnetIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
