% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_provision_byoip_cidr}
\alias{ec2_provision_byoip_cidr}
\title{Provisions an address range for use with your AWS resources through
bring your own IP addresses (BYOIP) and creates a corresponding address
pool}
\usage{
ec2_provision_byoip_cidr(Cidr, CidrAuthorizationContext, Description,
  DryRun)
}
\arguments{
\item{Cidr}{[required] The public IPv4 address range, in CIDR notation. The most specific
prefix that you can specify is /24. The address range cannot overlap
with another address range that you've brought to this or another
Region.}

\item{CidrAuthorizationContext}{A signed document that proves that you are authorized to bring the
specified IP address range to Amazon using BYOIP.}

\item{Description}{A description for the address range and the address pool.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Provisions an address range for use with your AWS resources through
bring your own IP addresses (BYOIP) and creates a corresponding address
pool. After the address range is provisioned, it is ready to be
advertised using AdvertiseByoipCidr.
}
\details{
AWS verifies that you own the address range and are authorized to
advertise it. You must ensure that the address range is registered to
you and that you created an RPKI ROA to authorize Amazon ASNs 16509 and
14618 to advertise the address range. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html}{Bring Your Own IP Addresses (BYOIP)}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Provisioning an address range is an asynchronous operation, so the call
returns immediately, but the address range is not ready to use until its
status changes from \code{pending-provision} to \code{provisioned}. To monitor the
status of an address range, use DescribeByoipCidrs. To allocate an
Elastic IP address from your address pool, use AllocateAddress with
either the specific address from the address pool or the ID of the
address pool.
}
\section{Request syntax}{
\preformatted{svc$provision_byoip_cidr(
  Cidr = "string",
  CidrAuthorizationContext = list(
    Message = "string",
    Signature = "string"
  ),
  Description = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
