% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_create_configuration_template}
\alias{elasticbeanstalk_create_configuration_template}
\title{Creates a configuration template}
\usage{
elasticbeanstalk_create_configuration_template(ApplicationName,
  TemplateName, SolutionStackName, PlatformArn, SourceConfiguration,
  EnvironmentId, Description, OptionSettings, Tags)
}
\arguments{
\item{ApplicationName}{[required] The name of the application to associate with this configuration
template. If no application is found with this name, AWS Elastic
Beanstalk returns an \code{InvalidParameterValue} error.}

\item{TemplateName}{[required] The name of the configuration template.

Constraint: This name must be unique per application.

Default: If a configuration template already exists with this name, AWS
Elastic Beanstalk returns an \code{InvalidParameterValue} error.}

\item{SolutionStackName}{The name of the solution stack used by this configuration. The solution
stack specifies the operating system, architecture, and application
server for a configuration template. It determines the set of
configuration options as well as the possible and default values.

Use ListAvailableSolutionStacks to obtain a list of available solution
stacks.

A solution stack name or a source configuration parameter must be
specified, otherwise AWS Elastic Beanstalk returns an
\code{InvalidParameterValue} error.

If a solution stack name is not specified and the source configuration
parameter is specified, AWS Elastic Beanstalk uses the same solution
stack as the source configuration template.}

\item{PlatformArn}{The ARN of the custom platform.}

\item{SourceConfiguration}{If specified, AWS Elastic Beanstalk uses the configuration values from
the specified configuration template to create a new configuration.

Values specified in the \code{OptionSettings} parameter of this call
overrides any values obtained from the \code{SourceConfiguration}.

If no configuration template is found, returns an
\code{InvalidParameterValue} error.

Constraint: If both the solution stack name parameter and the source
configuration parameters are specified, the solution stack of the source
configuration template must match the specified solution stack name or
else AWS Elastic Beanstalk returns an \code{InvalidParameterCombination}
error.}

\item{EnvironmentId}{The ID of the environment used with this configuration template.}

\item{Description}{Describes this configuration.}

\item{OptionSettings}{If specified, AWS Elastic Beanstalk sets the specified configuration
option to the requested value. The new value overrides the value
obtained from the solution stack or the source configuration template.}

\item{Tags}{Specifies the tags applied to the configuration template.}
}
\description{
Creates a configuration template. Templates are associated with a
specific application and are used to deploy different versions of the
application with the same configuration settings.
}
\details{
Templates aren't associated with any environment. The \code{EnvironmentName}
response element is always \code{null}.

Related Topics
\itemize{
\item DescribeConfigurationOptions
\item DescribeConfigurationSettings
\item ListAvailableSolutionStacks
}
}
\section{Request syntax}{
\preformatted{svc$create_configuration_template(
  ApplicationName = "string",
  TemplateName = "string",
  SolutionStackName = "string",
  PlatformArn = "string",
  SourceConfiguration = list(
    ApplicationName = "string",
    TemplateName = "string"
  ),
  EnvironmentId = "string",
  Description = "string",
  OptionSettings = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string",
      Value = "string"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# The following operation creates a configuration template named my-app-v1
# from the settings applied to an environment with the id e-rpqsewtp2j:
\donttest{svc$create_configuration_template(
  ApplicationName = "my-app",
  EnvironmentId = "e-rpqsewtp2j",
  TemplateName = "my-app-v1"
)}

}
\keyword{internal}
