% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_task_definition_families}
\alias{ecs_list_task_definition_families}
\title{Returns a list of task definition families that are registered to your
account (which may include task definition families that no longer have
any ACTIVE task definition revisions)}
\usage{
ecs_list_task_definition_families(familyPrefix, status, nextToken,
  maxResults)
}
\arguments{
\item{familyPrefix}{The \code{familyPrefix} is a string that is used to filter the results of
\code{ListTaskDefinitionFamilies}. If you specify a \code{familyPrefix}, only task
definition family names that begin with the \code{familyPrefix} string are
returned.}

\item{status}{The task definition family status with which to filter the
\code{ListTaskDefinitionFamilies} results. By default, both \code{ACTIVE} and
\code{INACTIVE} task definition families are listed. If this parameter is set
to \code{ACTIVE}, only task definition families that have an \code{ACTIVE} task
definition revision are returned. If this parameter is set to
\code{INACTIVE}, only task definition families that do not have any \code{ACTIVE}
task definition revisions are returned. If you paginate the resulting
output, be sure to keep the \code{status} value constant in each subsequent
request.}

\item{nextToken}{The \code{nextToken} value returned from a \code{ListTaskDefinitionFamilies}
request indicating that more results are available to fulfill the
request and further calls will be needed. If \code{maxResults} was provided,
it is possible the number of results to be fewer than \code{maxResults}.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of task definition family results returned by
\code{ListTaskDefinitionFamilies} in paginated output. When this parameter is
used, \code{ListTaskDefinitions} only returns \code{maxResults} results in a
single page along with a \code{nextToken} response element. The remaining
results of the initial request can be seen by sending another
\code{ListTaskDefinitionFamilies} request with the returned \code{nextToken}
value. This value can be between 1 and 100. If this parameter is not
used, then \code{ListTaskDefinitionFamilies} returns up to 100 results and a
\code{nextToken} value if applicable.}
}
\description{
Returns a list of task definition families that are registered to your
account (which may include task definition families that no longer have
any \code{ACTIVE} task definition revisions).
}
\details{
You can filter out task definition families that do not contain any
\code{ACTIVE} task definition revisions by setting the \code{status} parameter to
\code{ACTIVE}. You can also filter the results with the \code{familyPrefix}
parameter.
}
\section{Request syntax}{
\preformatted{svc$list_task_definition_families(
  familyPrefix = "string",
  status = "ACTIVE"|"INACTIVE"|"ALL",
  nextToken = "string",
  maxResults = 123
)
}
}

\examples{
# This example lists all of your registered task definition families.
\dontrun{svc$list_task_definition_families()}

# This example lists the task definition revisions that start with "hpcc".
\dontrun{svc$list_task_definition_families(
  familyPrefix = "hpcc"
)}

}
\keyword{internal}
