% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_untag_resource}
\alias{ecs_untag_resource}
\title{Deletes specified tags from a resource}
\usage{
ecs_untag_resource(resourceArn, tagKeys)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource from which to delete
tags. Currently, the supported resources are Amazon ECS capacity
providers, tasks, services, task definitions, clusters, and container
instances.}

\item{tagKeys}{[required] The keys of the tags to be removed.}
}
\description{
Deletes specified tags from a resource.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  resourceArn = "string",
  tagKeys = list(
    "string"
  )
)
}
}

\examples{
# This example deletes the 'team' tag from the 'dev' cluster.
\dontrun{svc$untag_resource(
  resourceArn = "arn:aws:ecs:region:aws_account_id:cluster/dev",
  tagKeys = list(
    "team"
  )
)}

}
\keyword{internal}
