% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_load_balancer_attribute}
\alias{lightsail_update_load_balancer_attribute}
\title{Updates the specified attribute for a load balancer}
\usage{
lightsail_update_load_balancer_attribute(loadBalancerName,
  attributeName, attributeValue)
}
\arguments{
\item{loadBalancerName}{[required] The name of the load balancer that you want to modify (e.g.,
\code{my-load-balancer}.}

\item{attributeName}{[required] The name of the attribute you want to update. Valid values are below.}

\item{attributeValue}{[required] The value that you want to specify for the attribute name.}
}
\description{
Updates the specified attribute for a load balancer. You can only update
one attribute at a time.
}
\details{
The \verb{update load balancer attribute} operation supports tag-based access
control via resource tags applied to the resource identified by
\verb{load balancer name}. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_load_balancer_attribute(
  loadBalancerName = "string",
  attributeName = "HealthCheckPath"|"SessionStickinessEnabled"|"SessionStickiness_LB_CookieDurationSeconds",
  attributeValue = "string"
)
}
}

\keyword{internal}
