% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_create_container_recipe}
\alias{imagebuilder_create_container_recipe}
\title{Creates a new container recipe}
\usage{
imagebuilder_create_container_recipe(
  containerType,
  name,
  description = NULL,
  semanticVersion,
  components,
  instanceConfiguration = NULL,
  dockerfileTemplateData = NULL,
  dockerfileTemplateUri = NULL,
  platformOverride = NULL,
  imageOsVersionOverride = NULL,
  parentImage,
  tags = NULL,
  workingDirectory = NULL,
  targetRepository,
  kmsKeyId = NULL,
  clientToken
)
}
\arguments{
\item{containerType}{[required] The type of container to create.}

\item{name}{[required] The name of the container recipe.}

\item{description}{The description of the container recipe.}

\item{semanticVersion}{[required] The semantic version of the container recipe. This version follows the
semantic version syntax.

The semantic version has four nodes:
\<major\>.\<minor\>.\<patch\>/\<build\>. You can assign values for the
first three, and can filter on all of them.

\strong{Assignment:} For the first three nodes you can assign any positive
integer value, including zero, with an upper limit of 2^30-1, or
1073741823 for each node. Image Builder automatically assigns the build
number to the fourth node.

\strong{Patterns:} You can use any numeric pattern that adheres to the
assignment requirements for the nodes that you can assign. For example,
you might choose a software version pattern, such as 1.0.0, or a date,
such as 2021.01.01.}

\item{components}{[required] Components for build and test that are included in the container recipe.
Recipes require a minimum of one build component, and can have a maximum
of 20 build and test components in any combination.}

\item{instanceConfiguration}{A group of options that can be used to configure an instance for
building and testing container images.}

\item{dockerfileTemplateData}{The Dockerfile template used to build your image as an inline data blob.}

\item{dockerfileTemplateUri}{The Amazon S3 URI for the Dockerfile that will be used to build your
container image.}

\item{platformOverride}{Specifies the operating system platform when you use a custom base
image.}

\item{imageOsVersionOverride}{Specifies the operating system version for the base image.}

\item{parentImage}{[required] The base image for the container recipe.}

\item{tags}{Tags that are attached to the container recipe.}

\item{workingDirectory}{The working directory for use during build and test workflows.}

\item{targetRepository}{[required] The destination repository for the container image.}

\item{kmsKeyId}{Identifies which KMS key is used to encrypt the container image.}

\item{clientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.}
}
\description{
Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_create_container_recipe/} for full documentation.
}
\keyword{internal}
