% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_distribution}
\alias{lightsail_create_distribution}
\title{Creates an Amazon Lightsail content delivery network (CDN) distribution}
\usage{
lightsail_create_distribution(
  distributionName,
  origin,
  defaultCacheBehavior,
  cacheBehaviorSettings = NULL,
  cacheBehaviors = NULL,
  bundleId,
  ipAddressType = NULL,
  tags = NULL
)
}
\arguments{
\item{distributionName}{[required] The name for the distribution.}

\item{origin}{[required] An object that describes the origin resource for the distribution, such
as a Lightsail instance, bucket, or load balancer.

The distribution pulls, caches, and serves content from the origin.}

\item{defaultCacheBehavior}{[required] An object that describes the default cache behavior for the
distribution.}

\item{cacheBehaviorSettings}{An object that describes the cache behavior settings for the
distribution.}

\item{cacheBehaviors}{An array of objects that describe the per-path cache behavior for the
distribution.}

\item{bundleId}{[required] The bundle ID to use for the distribution.

A distribution bundle describes the specifications of your distribution,
such as the monthly cost and monthly network transfer quota.

Use the \code{\link[=lightsail_get_distribution_bundles]{get_distribution_bundles}}
action to get a list of distribution bundle IDs that you can specify.}

\item{ipAddressType}{The IP address type for the distribution.

The possible values are \code{ipv4} for IPv4 only, and \code{dualstack} for IPv4
and IPv6.

The default value is \code{dualstack}.}

\item{tags}{The tag keys and optional values to add to the distribution during
create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\description{
Creates an Amazon Lightsail content delivery network (CDN) distribution.

See \url{https://www.paws-r-sdk.com/docs/lightsail_create_distribution/} for full documentation.
}
\keyword{internal}
