% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_update_budget_action}
\alias{budgets_update_budget_action}
\title{Updates a budget action}
\usage{
budgets_update_budget_action(AccountId, BudgetName, ActionId,
  NotificationType, ActionThreshold, Definition, ExecutionRoleArn,
  ApprovalModel, Subscribers)
}
\arguments{
\item{AccountId}{[required]}

\item{BudgetName}{[required]}

\item{ActionId}{[required] A system-generated universally unique identifier (UUID) for the action.}

\item{NotificationType}{}

\item{ActionThreshold}{}

\item{Definition}{}

\item{ExecutionRoleArn}{The role passed for action execution and reversion. Roles and actions
must be in the same account.}

\item{ApprovalModel}{This specifies if the action needs manual or automatic approval.}

\item{Subscribers}{}
}
\description{
Updates a budget action.
}
\section{Request syntax}{
\preformatted{svc$update_budget_action(
  AccountId = "string",
  BudgetName = "string",
  ActionId = "string",
  NotificationType = "ACTUAL"|"FORECASTED",
  ActionThreshold = list(
    ActionThresholdValue = 123.0,
    ActionThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE"
  ),
  Definition = list(
    IamActionDefinition = list(
      PolicyArn = "string",
      Roles = list(
        "string"
      ),
      Groups = list(
        "string"
      ),
      Users = list(
        "string"
      )
    ),
    ScpActionDefinition = list(
      PolicyId = "string",
      TargetIds = list(
        "string"
      )
    ),
    SsmActionDefinition = list(
      ActionSubType = "STOP_EC2_INSTANCES"|"STOP_RDS_INSTANCES",
      Region = "string",
      InstanceIds = list(
        "string"
      )
    )
  ),
  ExecutionRoleArn = "string",
  ApprovalModel = "AUTOMATIC"|"MANUAL",
  Subscribers = list(
    list(
      SubscriptionType = "SNS"|"EMAIL",
      Address = "string"
    )
  )
)
}
}

\keyword{internal}
