% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_update_subscriber}
\alias{budgets_update_subscriber}
\title{Updates a subscriber}
\usage{
budgets_update_subscriber(AccountId, BudgetName, Notification,
  OldSubscriber, NewSubscriber)
}
\arguments{
\item{AccountId}{[required] The \code{accountId} that is associated with the budget whose subscriber you
want to update.}

\item{BudgetName}{[required] The name of the budget whose subscriber you want to update.}

\item{Notification}{[required] The notification whose subscriber you want to update.}

\item{OldSubscriber}{[required] The previous subscriber that is associated with a budget notification.}

\item{NewSubscriber}{[required] The updated subscriber that is associated with a budget notification.}
}
\value{
An empty list.
}
\description{
Updates a subscriber.
}
\section{Request syntax}{
\preformatted{svc$update_subscriber(
  AccountId = "string",
  BudgetName = "string",
  Notification = list(
    NotificationType = "ACTUAL"|"FORECASTED",
    ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
    Threshold = 123.0,
    ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
    NotificationState = "OK"|"ALARM"
  ),
  OldSubscriber = list(
    SubscriptionType = "SNS"|"EMAIL",
    Address = "string"
  ),
  NewSubscriber = list(
    SubscriptionType = "SNS"|"EMAIL",
    Address = "string"
  )
)
}
}

\keyword{internal}
