% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_update_cost_category_definition}
\alias{costexplorer_update_cost_category_definition}
\title{_COST CATEGORY IS IN PUBLIC BETA FOR AWS BILLING AND COST MANAGEMENT AND
IS SUBJECT TO CHANGE}
\usage{
costexplorer_update_cost_category_definition(CostCategoryArn,
  RuleVersion, Rules)
}
\arguments{
\item{CostCategoryArn}{[required] The unique identifier for your Cost Category.}

\item{RuleVersion}{[required]}

\item{Rules}{[required] \code{UpdateCostCategoryDefinition} supports dimensions, Tags, and nested
expressions. Currently the only dimensions supported is
\code{LINKED_ACCOUNT}.

Root level \code{OR} is not supported. We recommend you create a separate
rule instead.

Rules are processed in order. If there are multiple rules that match the
line item, then the first rule to match is used to determine that Cost
Category value.}
}
\description{
\emph{\strong{Cost Category is in public beta for AWS Billing and Cost Management
and is subject to change. Your use of Cost Categories is subject to the
Beta Service Participation terms of the \href{https://aws.amazon.com/service-terms/}{AWS Service Terms} (Section 1.10).}}
}
\details{
Updates an existing Cost Category. Changes made to the Cost Category
rules will be used to categorize the current month's expenses and future
expenses. This won't change categorization for the previous months.
}
\section{Request syntax}{
\preformatted{svc$update_cost_category_definition(
  CostCategoryArn = "string",
  RuleVersion = "CostCategoryExpression.v1",
  Rules = list(
    list(
      Value = "string",
      Rule = list(
        Or = list(
          list()
        ),
        And = list(
          list()
        ),
        Not = list(),
        Dimensions = list(
          Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION",
          Values = list(
            "string"
          )
        ),
        Tags = list(
          Key = "string",
          Values = list(
            "string"
          )
        ),
        CostCategories = list(
          Key = "string",
          Values = list(
            "string"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
