% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_current_metric_data}
\alias{connect_get_current_metric_data}
\title{Gets the real-time metric data from the specified Amazon Connect
instance}
\usage{
connect_get_current_metric_data(InstanceId, Filters, Groupings,
  CurrentMetrics, NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{Filters}{[required] The queues, up to 100, or channels, to use to filter the metrics
returned. Metric data is retrieved only for the resources associated
with the queues or channels included in the filter. You can include both
queue IDs and queue ARNs in the same request. The only supported channel
is \code{VOICE}.}

\item{Groupings}{The grouping applied to the metrics returned. For example, when grouped
by \code{QUEUE}, the metrics returned apply to each queue rather than
aggregated for all queues. If you group by \code{CHANNEL}, you should include
a Channels filter. The only supported channel is \code{VOICE}.

If no \code{Grouping} is included in the request, a summary of metrics is
returned.}

\item{CurrentMetrics}{[required] The metrics to retrieve. Specify the name and unit for each metric. The
following metrics are available. For a description of each metric, see
\href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html}{Real-time Metrics Definitions}
in the \emph{Amazon Connect Administrator Guide}.
\subsection{AGENTS\\_AFTER\\_CONTACT\\_WORK}{

Unit: COUNT
}

\subsection{AGENTS\\_AVAILABLE}{

Unit: COUNT
}

\subsection{AGENTS\\_ERROR}{

Unit: COUNT
}

\subsection{AGENTS\\_NON\\_PRODUCTIVE}{

Unit: COUNT
}

\subsection{AGENTS\\_ON\\_CALL}{

Unit: COUNT
}

\subsection{AGENTS\\_ON\\_CONTACT}{

Unit: COUNT
}

\subsection{AGENTS\\_ONLINE}{

Unit: COUNT
}

\subsection{AGENTS\\_STAFFED}{

Unit: COUNT
}

\subsection{CONTACTS\\_IN\\_QUEUE}{

Unit: COUNT
}

\subsection{CONTACTS\\_SCHEDULED}{

Unit: COUNT
}

\subsection{OLDEST\\_CONTACT\\_AGE}{

Unit: SECONDS
}

\subsection{SLOTS\\_ACTIVE}{

Unit: COUNT
}

\subsection{SLOTS\\_AVAILABLE}{

Unit: COUNT
}}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.

The token expires after 5 minutes from the time it is created.
Subsequent requests that use the token must use the same request
parameters as the request that generated the token.}

\item{MaxResults}{The maximimum number of results to return per page.}
}
\description{
Gets the real-time metric data from the specified Amazon Connect
instance.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-reports.html}{Real-time Metrics Reports}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_current_metric_data(
  InstanceId = "string",
  Filters = list(
    Queues = list(
      "string"
    ),
    Channels = list(
      "VOICE"|"CHAT"
    )
  ),
  Groupings = list(
    "QUEUE"|"CHANNEL"
  ),
  CurrentMetrics = list(
    list(
      Name = "AGENTS_ONLINE"|"AGENTS_AVAILABLE"|"AGENTS_ON_CALL"|"AGENTS_NON_PRODUCTIVE"|"AGENTS_AFTER_CONTACT_WORK"|"AGENTS_ERROR"|"AGENTS_STAFFED"|"CONTACTS_IN_QUEUE"|"OLDEST_CONTACT_AGE"|"CONTACTS_SCHEDULED"|"AGENTS_ON_CONTACT"|"SLOTS_ACTIVE"|"SLOTS_AVAILABLE",
      Unit = "SECONDS"|"COUNT"|"PERCENT"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
