# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Connect Customer Profiles
#'
#' @description
#' Welcome to the Amazon Connect Customer Profiles API Reference. This
#' guide provides information about the Amazon Connect Customer Profiles
#' API, including supported operations, data types, parameters, and
#' schemas.
#' 
#' Amazon Connect Customer Profiles is a unified customer profile for your
#' contact center that has pre-built connectors powered by AppFlow that
#' make it easy to combine customer information from third party
#' applications, such as Salesforce (CRM), ServiceNow (ITSM), and your
#' enterprise resource planning (ERP), with contact history from your
#' Amazon Connect contact center.
#' 
#' If you're new to Amazon Connect , you might find it helpful to also
#' review the [Amazon Connect Administrator
#' Guide](https://docs.aws.amazon.com/connect/latest/adminguide/what-is-amazon-connect.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- customerprofiles(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- customerprofiles()
#' svc$add_profile_key(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=customerprofiles_add_profile_key]{add_profile_key} \tab Associates a new key value with a specific profile, such as a Contact Trace Record (CTR) ContactId\cr
#'  \link[=customerprofiles_create_domain]{create_domain} \tab Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys\cr
#'  \link[=customerprofiles_create_integration_workflow]{create_integration_workflow} \tab Creates an integration workflow\cr
#'  \link[=customerprofiles_create_profile]{create_profile} \tab Creates a standard profile\cr
#'  \link[=customerprofiles_delete_domain]{delete_domain} \tab Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects\cr
#'  \link[=customerprofiles_delete_integration]{delete_integration} \tab Removes an integration from a specific domain\cr
#'  \link[=customerprofiles_delete_profile]{delete_profile} \tab Deletes the standard customer profile and all data pertaining to the profile\cr
#'  \link[=customerprofiles_delete_profile_key]{delete_profile_key} \tab Removes a searchable key from a customer profile\cr
#'  \link[=customerprofiles_delete_profile_object]{delete_profile_object} \tab Removes an object associated with a profile of a given ProfileObjectType\cr
#'  \link[=customerprofiles_delete_profile_object_type]{delete_profile_object_type} \tab Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type\cr
#'  \link[=customerprofiles_delete_workflow]{delete_workflow} \tab Deletes the specified workflow and all its corresponding resources\cr
#'  \link[=customerprofiles_get_auto_merging_preview]{get_auto_merging_preview} \tab Tests the auto-merging settings of your Identity Resolution Job without merging your data\cr
#'  \link[=customerprofiles_get_domain]{get_domain} \tab Returns information about a specific domain\cr
#'  \link[=customerprofiles_get_identity_resolution_job]{get_identity_resolution_job} \tab Returns information about an Identity Resolution Job in a specific domain\cr
#'  \link[=customerprofiles_get_integration]{get_integration} \tab Returns an integration for a domain\cr
#'  \link[=customerprofiles_get_matches]{get_matches} \tab Before calling this API, use CreateDomain or UpdateDomain to enable identity resolution: set Matching to true\cr
#'  \link[=customerprofiles_get_profile_object_type]{get_profile_object_type} \tab Returns the object types for a specific domain\cr
#'  \link[=customerprofiles_get_profile_object_type_template]{get_profile_object_type_template} \tab Returns the template information for a specific object type\cr
#'  \link[=customerprofiles_get_workflow]{get_workflow} \tab Get details of specified workflow\cr
#'  \link[=customerprofiles_get_workflow_steps]{get_workflow_steps} \tab Get granular list of steps in workflow\cr
#'  \link[=customerprofiles_list_account_integrations]{list_account_integrations} \tab Lists all of the integrations associated to a specific URI in the AWS account\cr
#'  \link[=customerprofiles_list_domains]{list_domains} \tab Returns a list of all the domains for an AWS account that have been created\cr
#'  \link[=customerprofiles_list_identity_resolution_jobs]{list_identity_resolution_jobs} \tab Lists all of the Identity Resolution Jobs in your domain\cr
#'  \link[=customerprofiles_list_integrations]{list_integrations} \tab Lists all of the integrations in your domain\cr
#'  \link[=customerprofiles_list_profile_objects]{list_profile_objects} \tab Returns a list of objects associated with a profile of a given ProfileObjectType\cr
#'  \link[=customerprofiles_list_profile_object_types]{list_profile_object_types} \tab Lists all of the templates available within the service\cr
#'  \link[=customerprofiles_list_profile_object_type_templates]{list_profile_object_type_templates} \tab Lists all of the template information for object types\cr
#'  \link[=customerprofiles_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with an Amazon Connect Customer Profiles resource\cr
#'  \link[=customerprofiles_list_workflows]{list_workflows} \tab Query to list all workflows\cr
#'  \link[=customerprofiles_merge_profiles]{merge_profiles} \tab Runs an AWS Lambda job that does the following:\cr
#'  \link[=customerprofiles_put_integration]{put_integration} \tab Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect\cr
#'  \link[=customerprofiles_put_profile_object]{put_profile_object} \tab Adds additional objects to customer profiles of a given ObjectType\cr
#'  \link[=customerprofiles_put_profile_object_type]{put_profile_object_type} \tab Defines a ProfileObjectType\cr
#'  \link[=customerprofiles_search_profiles]{search_profiles} \tab Searches for profiles within a specific domain name using name, phone number, email address, account number, or a custom defined index\cr
#'  \link[=customerprofiles_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource\cr
#'  \link[=customerprofiles_untag_resource]{untag_resource} \tab Removes one or more tags from the specified Amazon Connect Customer Profiles resource\cr
#'  \link[=customerprofiles_update_domain]{update_domain} \tab Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key\cr
#'  \link[=customerprofiles_update_profile]{update_profile} \tab Updates the properties of a profile
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname customerprofiles
#' @export
customerprofiles <- function(config = list()) {
  svc <- .customerprofiles$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.customerprofiles <- list()

.customerprofiles$operations <- list()

.customerprofiles$metadata <- list(
  service_name = "customerprofiles",
  endpoints = list("*" = list(endpoint = "profile.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "profile.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "profile.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "profile.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Customer Profiles",
  api_version = "2020-08-15",
  signing_name = "profile",
  json_version = "1.1",
  target_prefix = ""
)

.customerprofiles$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.customerprofiles$metadata, handlers, config)
}
