% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_metric_data_v2}
\alias{connect_get_metric_data_v2}
\title{Gets metric data from the specified Amazon Connect instance}
\usage{
connect_get_metric_data_v2(
  ResourceArn,
  StartTime,
  EndTime,
  Interval = NULL,
  Filters,
  Groupings = NULL,
  Metrics,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource. This includes the
\code{instanceId} an Amazon Connect instance.}

\item{StartTime}{[required] The timestamp, in UNIX Epoch time format, at which to start the
reporting interval for the retrieval of historical metrics data. The
time must be before the end time timestamp. The start and end time
depends on the \code{IntervalPeriod} selected. By default the time range
between start and end time is 35 days. Historical metrics are available
for 3 months.}

\item{EndTime}{[required] The timestamp, in UNIX Epoch time format, at which to end the reporting
interval for the retrieval of historical metrics data. The time must be
later than the start time timestamp. It cannot be later than the current
timestamp.}

\item{Interval}{The interval period and timezone to apply to returned metrics.
\itemize{
\item \code{IntervalPeriod}: An aggregated grouping applied to request metrics.
Valid \code{IntervalPeriod} values are: \code{FIFTEEN_MIN} | \code{THIRTY_MIN} |
\code{HOUR} | \code{DAY} | \code{WEEK} | \code{TOTAL}.

For example, if \code{IntervalPeriod} is selected \code{THIRTY_MIN},
\code{StartTime} and \code{EndTime} differs by 1 day, then Amazon Connect
returns 48 results in the response. Each result is aggregated by the
THIRTY_MIN period. By default Amazon Connect aggregates results
based on the \code{TOTAL} interval period.

The following list describes restrictions on \code{StartTime} and
\code{EndTime} based on which \code{IntervalPeriod} is requested.
\itemize{
\item \code{FIFTEEN_MIN}: The difference between \code{StartTime} and \code{EndTime}
must be less than 3 days.
\item \code{THIRTY_MIN}: The difference between \code{StartTime} and \code{EndTime}
must be less than 3 days.
\item \code{HOUR}: The difference between \code{StartTime} and \code{EndTime} must be
less than 3 days.
\item \code{DAY}: The difference between \code{StartTime} and \code{EndTime} must be
less than 35 days.
\item \code{WEEK}: The difference between \code{StartTime} and \code{EndTime} must be
less than 35 days.
\item \code{TOTAL}: The difference between \code{StartTime} and \code{EndTime} must
be less than 35 days.
}
\item \code{TimeZone}: The timezone applied to requested metrics.
}}

\item{Filters}{[required] The filters to apply to returned metrics. You can filter on the
following resources:
\itemize{
\item Queues
\item Routing profiles
\item Agents
\item Channels
\item User hierarchy groups
\item Feature
}

At least one filter must be passed from queues, routing profiles,
agents, or user hierarchy groups.

To filter by phone number, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html}{Create a historical metrics report}
in the \emph{Amazon Connect Administrator's Guide}.

Note the following limits:
\itemize{
\item \strong{Filter keys}: A maximum of 5 filter keys are supported in a
single request. Valid filter keys: \code{QUEUE} | \code{ROUTING_PROFILE} |
\code{AGENT} | \code{CHANNEL} | \code{AGENT_HIERARCHY_LEVEL_ONE} |
\code{AGENT_HIERARCHY_LEVEL_TWO} | \code{AGENT_HIERARCHY_LEVEL_THREE} |
\code{AGENT_HIERARCHY_LEVEL_FOUR} | \code{AGENT_HIERARCHY_LEVEL_FIVE} |
\code{FEATURE} | \code{contact/segmentAttributes/connect:Subtype}
\item \strong{Filter values}: A maximum of 100 filter values are supported in a
single request. VOICE, CHAT, and TASK are valid \code{filterValue} for
the CHANNEL filter key. They do not count towards limitation of 100
filter values. For example, a GetMetricDataV2 request can filter by
50 queues, 35 agents, and 15 routing profiles for a total of 100
filter values, along with 3 channel filters.

\code{contact_lens_conversational_analytics} is a valid filterValue for
the \code{FEATURE} filter key. It is available only to contacts analyzed
by Contact Lens conversational analytics.

\code{connect:Chat}, \code{connect:SMS}, \code{connect:Telephony}, and
\code{connect:WebRTC} are valid \code{filterValue} examples (not exhaustive)
for the \verb{contact/segmentAttributes/connect:Subtype filter} key.
}}

\item{Groupings}{The grouping applied to the metrics that are returned. For example, when
results are grouped by queue, the metrics returned are grouped by queue.
The values that are returned apply to the metrics for each queue. They
are not aggregated for all queues.

If no grouping is specified, a summary of all metrics is returned.

Valid grouping keys: \code{QUEUE} | \code{ROUTING_PROFILE} | \code{AGENT} | \code{CHANNEL} |
\code{AGENT_HIERARCHY_LEVEL_ONE} | \code{AGENT_HIERARCHY_LEVEL_TWO} |
\code{AGENT_HIERARCHY_LEVEL_THREE} | \code{AGENT_HIERARCHY_LEVEL_FOUR} |
\code{AGENT_HIERARCHY_LEVEL_FIVE},
\code{contact/segmentAttributes/connect:Subtype}}

\item{Metrics}{[required] The metrics to retrieve. Specify the name, groupings, and filters for
each metric. The following historical metrics are available. For a
description of each metric, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html}{Historical metrics definitions}
in the \emph{Amazon Connect Administrator's Guide}.

\strong{ABANDONMENT_RATE}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

\strong{AGENT_ADHERENT_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_ANSWER_RATE}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_NON_ADHERENT_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_NON_RESPONSE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

Data for this metric is available starting from October 1, 2023 0:00:00
GMT.

\strong{AGENT_OCCUPANCY}

Unit: Percentage

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

\strong{AGENT_SCHEDULE_ADHERENCE}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AGENT_SCHEDULED_TIME}

This metric is available only in Amazon Web Services Regions where
\href{https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region}{Forecasting, capacity planning, and scheduling}
is available.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_ABANDON_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

\strong{AVG_ACTIVE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_AFTER_CONTACT_WORK_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{AVG_AGENT_CONNECTING_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. For now, this metric only
supports the following as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND} |
\code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

The \code{Negate} key in Metric Level Filters is not applicable for this
metric.

\strong{AVG_AGENT_PAUSE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{AVG_CONTACT_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{AVG_CONVERSATION_DURATION}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

\strong{AVG_GREETING_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_HANDLE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{AVG_HOLD_TIME_ALL_CONTACTS}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_HOLDS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERACTION_AND_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_INTERACTION_TIME}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{AVG_INTERRUPTIONS_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_INTERRUPTION_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_NON_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_QUEUE_ANSWER_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{AVG_RESOLUTION_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

\strong{AVG_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_TALK_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{AVG_TALK_TIME_CUSTOMER}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{CONTACTS_ABANDONED}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{CONTACTS_CREATED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}

Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HANDLED}

Unit: Count

Valid metric filter key: \code{INITIATION_METHOD}, \code{DISCONNECT_REASON}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_HOLD_ABANDONS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{CONTACTS_ON_HOLD_AGENT_DISCONNECT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_PUT_ON_HOLD}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_TRANSFERRED_OUT_EXTERNAL}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_TRANSFERRED_OUT_INTERNAL}

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{CONTACTS_QUEUED}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{CONTACTS_RESOLVED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

Threshold: For \code{ThresholdValue} enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

\strong{CONTACTS_TRANSFERRED_OUT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype

Feature is a valid filter but not a valid grouping.

\strong{CONTACTS_TRANSFERRED_OUT_BY_AGENT}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{CONTACTS_TRANSFERRED_OUT_FROM_QUEUE}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{MAX_QUEUED_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{PERCENT_NON_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{PERCENT_TALK_TIME}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{PERCENT_TALK_TIME_AGENT}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{PERCENT_TALK_TIME_CUSTOMER}

This metric is available only for contacts analyzed by Contact Lens
conversational analytics.

Unit: Percentage

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{SERVICE_LEVEL}

You can include up to 20 SERVICE_LEVEL metrics in a request.

Unit: Percent

Valid groupings and filters: Queue, Channel, Routing Profile

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

\strong{SUM_AFTER_CONTACT_WORK_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_CONNECTING_TIME_AGENT}

Unit: Seconds

Valid metric filter key: \code{INITIATION_METHOD}. This metric only supports
the following filter keys as \code{INITIATION_METHOD}: \code{INBOUND} | \code{OUTBOUND}
| \code{CALLBACK} | \code{API}

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

The \code{Negate} key in Metric Level Filters is not applicable for this
metric.

\strong{SUM_CONTACT_FLOW_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_CONTACT_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_CONTACTS_ANSWERED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

\strong{SUM_CONTACTS_ABANDONED_IN_X}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").

\strong{SUM_CONTACTS_DISCONNECTED}

Valid metric filter key: \code{DISCONNECT_REASON}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy, contact/segmentAttributes/connect:Subtype

\strong{SUM_ERROR_STATUS_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_HANDLE_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_HOLD_TIME}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_IDLE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

\strong{SUM_INTERACTION_AND_HOLD_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_INTERACTION_TIME}

Unit: Seconds

Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
Agent Hierarchy

\strong{SUM_NON_PRODUCTIVE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

\strong{SUM_ONLINE_TIME_AGENT}

Unit: Seconds

Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy

\strong{SUM_RETRY_CALLBACK_ATTEMPTS}

Unit: Count

Valid groupings and filters: Queue, Channel, Routing Profile,
contact/segmentAttributes/connect:Subtype}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\description{
Gets metric data from the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_get_metric_data_v2/} for full documentation.
}
\keyword{internal}
