% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_get_auto_merging_preview}
\alias{customerprofiles_get_auto_merging_preview}
\title{Tests the auto-merging settings of your Identity Resolution Job without
merging your data}
\usage{
customerprofiles_get_auto_merging_preview(
  DomainName,
  Consolidation,
  ConflictResolution,
  MinAllowedConfidenceScoreForMerging = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{Consolidation}{[required] A list of matching attributes that represent matching criteria.}

\item{ConflictResolution}{[required] How the auto-merging process should resolve conflicts between different
profiles.}

\item{MinAllowedConfidenceScoreForMerging}{Minimum confidence score required for profiles within a matching group
to be merged during the auto-merge process.}
}
\description{
Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a sample of matching groups from the existing matching results, and applies the automerging settings that you provided. You can then view the number of profiles in the sample, the number of matches, and the number of profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching list.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_get_auto_merging_preview/} for full documentation.
}
\keyword{internal}
