% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_remove_tags_from_resource}
\alias{rds_remove_tags_from_resource}
\title{Removes metadata tags from an Amazon RDS resource}
\usage{
rds_remove_tags_from_resource(ResourceName, TagKeys)
}
\arguments{
\item{ResourceName}{[required] The Amazon RDS resource that the tags are removed from. This value is an
Amazon Resource Name (ARN). For information about creating an ARN, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing}{Constructing an ARN for Amazon RDS}
in the \emph{Amazon RDS User Guide.}}

\item{TagKeys}{[required] The tag key (name) of the tag to be removed.}
}
\description{
Removes metadata tags from an Amazon RDS resource.

For an overview on tagging an Amazon RDS resource, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html}{Tagging Amazon RDS Resources}
in the \emph{Amazon RDS User Guide.}
}
\section{Request syntax}{
\preformatted{svc$remove_tags_from_resource(
  ResourceName = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
