% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_event_subscription}
\alias{rds_modify_event_subscription}
\title{Modifies an existing RDS event notification subscription}
\usage{
rds_modify_event_subscription(SubscriptionName, SnsTopicArn, SourceType,
  EventCategories, Enabled)
}
\arguments{
\item{SubscriptionName}{[required] The name of the RDS event notification subscription.}

\item{SnsTopicArn}{The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.}

\item{SourceType}{The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you would set
this parameter to db-instance. If this value isn't specified, all events
are returned.

Valid values: \code{db-instance} | \code{db-cluster} | \code{db-parameter-group} |
\code{db-security-group} | \code{db-snapshot} | \code{db-cluster-snapshot}}

\item{EventCategories}{A list of event categories for a source type (\code{SourceType}) that you
want to subscribe to. You can see a list of the categories for a given
source type in
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html}{Events}
in the \emph{Amazon RDS User Guide} or by using the
\code{\link[=rds_describe_event_categories]{describe_event_categories}} operation.}

\item{Enabled}{A value that indicates whether to activate the subscription.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventSubscription = list(
    CustomerAwsId = "string",
    CustSubscriptionId = "string",
    SnsTopicArn = "string",
    Status = "string",
    SubscriptionCreationTime = "string",
    SourceType = "string",
    SourceIdsList = list(
      "string"
    ),
    EventCategoriesList = list(
      "string"
    ),
    Enabled = TRUE|FALSE,
    EventSubscriptionArn = "string"
  )
)
}
}
\description{
Modifies an existing RDS event notification subscription. You can't
modify the source identifiers using this call. To change source
identifiers for a subscription, use the
\code{\link[=rds_add_source_identifier_to_subscription]{add_source_identifier_to_subscription}}
and
\code{\link[=rds_remove_source_identifier_from_subscription]{remove_source_identifier_from_subscription}}
calls.

You can see a list of the event categories for a given source type
(\code{SourceType}) in
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html}{Events}
in the \emph{Amazon RDS User Guide} or by using the
\code{\link[=rds_describe_event_categories]{describe_event_categories}} operation.
}
\section{Request syntax}{
\preformatted{svc$modify_event_subscription(
  SubscriptionName = "string",
  SnsTopicArn = "string",
  SourceType = "string",
  EventCategories = list(
    "string"
  ),
  Enabled = TRUE|FALSE
)
}
}

\keyword{internal}
