% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_current_db_cluster_capacity}
\alias{rds_modify_current_db_cluster_capacity}
\title{Set the capacity of an Aurora Serverless DB cluster to a specific value}
\usage{
rds_modify_current_db_cluster_capacity(DBClusterIdentifier, Capacity,
  SecondsBeforeTimeout, TimeoutAction)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the cluster being modified. This parameter
isn't case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DB cluster.
}}

\item{Capacity}{The DB cluster capacity.

When you change the capacity of a paused Aurora Serverless DB cluster,
it automatically resumes.

Constraints:
\itemize{
\item For Aurora MySQL, valid capacity values are \code{1}, \code{2}, \code{4}, \code{8},
\code{16}, \code{32}, \code{64}, \code{128}, and \code{256}.
\item For Aurora PostgreSQL, valid capacity values are \code{2}, \code{4}, \code{8},
\code{16}, \code{32}, \code{64}, \code{192}, and \code{384}.
}}

\item{SecondsBeforeTimeout}{The amount of time, in seconds, that Aurora Serverless tries to find a
scaling point to perform seamless scaling before enforcing the timeout
action. The default is 300.
\itemize{
\item Value must be from 10 through 600.
}}

\item{TimeoutAction}{The action to take when the timeout is reached, either
\code{ForceApplyCapacityChange} or \code{RollbackCapacityChange}.

\code{ForceApplyCapacityChange}, the default, sets the capacity to the
specified value as soon as possible.

\code{RollbackCapacityChange} ignores the capacity change if a scaling point
isn't found in the timeout period.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBClusterIdentifier = "string",
  PendingCapacity = 123,
  CurrentCapacity = 123,
  SecondsBeforeTimeout = 123,
  TimeoutAction = "string"
)
}
}
\description{
Set the capacity of an Aurora Serverless DB cluster to a specific value.

Aurora Serverless scales seamlessly based on the workload on the DB
cluster. In some cases, the capacity might not scale fast enough to meet
a sudden change in workload, such as a large number of new transactions.
Call
\code{\link[=rds_modify_current_db_cluster_capacity]{modify_current_db_cluster_capacity}}
to set the capacity explicitly.

After this call sets the DB cluster capacity, Aurora Serverless can
automatically scale the DB cluster based on the cooldown period for
scaling up and the cooldown period for scaling down.

For more information about Aurora Serverless, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html}{Using Amazon Aurora Serverless}
in the \emph{Amazon Aurora User Guide}.

If you call
\code{\link[=rds_modify_current_db_cluster_capacity]{modify_current_db_cluster_capacity}}
with the default \code{TimeoutAction}, connections that prevent Aurora
Serverless from finding a scaling point might be dropped. For more
information about scaling points, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling}{Autoscaling for Aurora Serverless}
in the \emph{Amazon Aurora User Guide}.

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$modify_current_db_cluster_capacity(
  DBClusterIdentifier = "string",
  Capacity = 123,
  SecondsBeforeTimeout = 123,
  TimeoutAction = "string"
)
}
}

\keyword{internal}
