% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_snapshot_schedule}
\alias{redshift_modify_snapshot_schedule}
\title{Modifies a snapshot schedule}
\usage{
redshift_modify_snapshot_schedule(ScheduleIdentifier,
  ScheduleDefinitions)
}
\arguments{
\item{ScheduleIdentifier}{[required] A unique alphanumeric identifier of the schedule to modify.}

\item{ScheduleDefinitions}{[required] An updated list of schedule definitions. A schedule definition is made
up of schedule expressions, for example, "cron(30 12 *)" or "rate(12
hours)".}
}
\value{
A list with the following syntax:\preformatted{list(
  ScheduleDefinitions = list(
    "string"
  ),
  ScheduleIdentifier = "string",
  ScheduleDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  NextInvocations = list(
    as.POSIXct(
      "2015-01-01"
    )
  ),
  AssociatedClusterCount = 123,
  AssociatedClusters = list(
    list(
      ClusterIdentifier = "string",
      ScheduleAssociationState = "MODIFYING"|"ACTIVE"|"FAILED"
    )
  )
)
}
}
\description{
Modifies a snapshot schedule. Any schedule associated with a cluster is
modified asynchronously.
}
\section{Request syntax}{
\preformatted{svc$modify_snapshot_schedule(
  ScheduleIdentifier = "string",
  ScheduleDefinitions = list(
    "string"
  )
)
}
}

\keyword{internal}
