% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_usage_limit}
\alias{redshift_modify_usage_limit}
\title{Modifies a usage limit in a cluster}
\usage{
redshift_modify_usage_limit(UsageLimitId, Amount, BreachAction)
}
\arguments{
\item{UsageLimitId}{[required] The identifier of the usage limit to modify.}

\item{Amount}{The new limit amount. For more information about this parameter, see
UsageLimit.}

\item{BreachAction}{The new action that Amazon Redshift takes when the limit is reached. For
more information about this parameter, see UsageLimit.}
}
\value{
A list with the following syntax:\preformatted{list(
  UsageLimitId = "string",
  ClusterIdentifier = "string",
  FeatureType = "spectrum"|"concurrency-scaling",
  LimitType = "time"|"data-scanned",
  Amount = 123,
  Period = "daily"|"weekly"|"monthly",
  BreachAction = "log"|"emit-metric"|"disable",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Modifies a usage limit in a cluster. You can't modify the feature type
or period of a usage limit.
}
\section{Request syntax}{
\preformatted{svc$modify_usage_limit(
  UsageLimitId = "string",
  Amount = 123,
  BreachAction = "log"|"emit-metric"|"disable"
)
}
}

\keyword{internal}
