% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_get_deployment_group}
\alias{codedeploy_get_deployment_group}
\title{Gets information about a deployment group}
\usage{
codedeploy_get_deployment_group(applicationName, deploymentGroupName)
}
\arguments{
\item{applicationName}{[required] The name of an AWS CodeDeploy application associated with the IAM user
or AWS account.}

\item{deploymentGroupName}{[required] The name of a deployment group for the specified application.}
}
\value{
A list with the following syntax:\preformatted{list(
  deploymentGroupInfo = list(
    applicationName = "string",
    deploymentGroupId = "string",
    deploymentGroupName = "string",
    deploymentConfigName = "string",
    ec2TagFilters = list(
      list(
        Key = "string",
        Value = "string",
        Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
      )
    ),
    onPremisesInstanceTagFilters = list(
      list(
        Key = "string",
        Value = "string",
        Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
      )
    ),
    autoScalingGroups = list(
      list(
        name = "string",
        hook = "string"
      )
    ),
    serviceRoleArn = "string",
    targetRevision = list(
      revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
      s3Location = list(
        bucket = "string",
        key = "string",
        bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
        version = "string",
        eTag = "string"
      ),
      gitHubLocation = list(
        repository = "string",
        commitId = "string"
      ),
      string = list(
        content = "string",
        sha256 = "string"
      ),
      appSpecContent = list(
        content = "string",
        sha256 = "string"
      )
    ),
    triggerConfigurations = list(
      list(
        triggerName = "string",
        triggerTargetArn = "string",
        triggerEvents = list(
          "DeploymentStart"|"DeploymentSuccess"|"DeploymentFailure"|"DeploymentStop"|"DeploymentRollback"|"DeploymentReady"|"InstanceStart"|"InstanceSuccess"|"InstanceFailure"|"InstanceReady"
        )
      )
    ),
    alarmConfiguration = list(
      enabled = TRUE|FALSE,
      ignorePollAlarmFailure = TRUE|FALSE,
      alarms = list(
        list(
          name = "string"
        )
      )
    ),
    autoRollbackConfiguration = list(
      enabled = TRUE|FALSE,
      events = list(
        "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
      )
    ),
    deploymentStyle = list(
      deploymentType = "IN_PLACE"|"BLUE_GREEN",
      deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
    ),
    blueGreenDeploymentConfiguration = list(
      terminateBlueInstancesOnDeploymentSuccess = list(
        action = "TERMINATE"|"KEEP_ALIVE",
        terminationWaitTimeInMinutes = 123
      ),
      deploymentReadyOption = list(
        actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
        waitTimeInMinutes = 123
      ),
      greenFleetProvisioningOption = list(
        action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
      )
    ),
    loadBalancerInfo = list(
      elbInfoList = list(
        list(
          name = "string"
        )
      ),
      targetGroupInfoList = list(
        list(
          name = "string"
        )
      ),
      targetGroupPairInfoList = list(
        list(
          targetGroups = list(
            list(
              name = "string"
            )
          ),
          prodTrafficRoute = list(
            listenerArns = list(
              "string"
            )
          ),
          testTrafficRoute = list(
            listenerArns = list(
              "string"
            )
          )
        )
      )
    ),
    lastSuccessfulDeployment = list(
      deploymentId = "string",
      status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
      endTime = as.POSIXct(
        "2015-01-01"
      ),
      createTime = as.POSIXct(
        "2015-01-01"
      )
    ),
    lastAttemptedDeployment = list(
      deploymentId = "string",
      status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
      endTime = as.POSIXct(
        "2015-01-01"
      ),
      createTime = as.POSIXct(
        "2015-01-01"
      )
    ),
    ec2TagSet = list(
      ec2TagSetList = list(
        list(
          list(
            Key = "string",
            Value = "string",
            Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
          )
        )
      )
    ),
    onPremisesTagSet = list(
      onPremisesTagSetList = list(
        list(
          list(
            Key = "string",
            Value = "string",
            Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
          )
        )
      )
    ),
    computePlatform = "Server"|"Lambda"|"ECS",
    ecsServices = list(
      list(
        serviceName = "string",
        clusterName = "string"
      )
    )
  )
)
}
}
\description{
Gets information about a deployment group.
}
\section{Request syntax}{
\preformatted{svc$get_deployment_group(
  applicationName = "string",
  deploymentGroupName = "string"
)
}
}

\keyword{internal}
