# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include appstream_service.R
NULL

#' Associates the specified fleet with the specified stack
#'
#' @description
#' Associates the specified fleet with the specified stack.
#'
#' @usage
#' appstream_associate_fleet(FleetName, StackName)
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param StackName &#91;required&#93; The name of the stack.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_fleet(
#'   FleetName = "string",
#'   StackName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_associate_fleet
appstream_associate_fleet <- function(FleetName, StackName) {
  op <- new_operation(
    name = "AssociateFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$associate_fleet_input(FleetName = FleetName, StackName = StackName)
  output <- .appstream$associate_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$associate_fleet <- appstream_associate_fleet

#' Associates the specified users with the specified stacks
#'
#' @description
#' Associates the specified users with the specified stacks. Users in a
#' user pool cannot be assigned to stacks with fleets that are joined to an
#' Active Directory domain.
#'
#' @usage
#' appstream_batch_associate_user_stack(UserStackAssociations)
#'
#' @param UserStackAssociations &#91;required&#93; The list of UserStackAssociation objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   errors = list(
#'     list(
#'       UserStackAssociation = list(
#'         StackName = "string",
#'         UserName = "string",
#'         AuthenticationType = "API"|"SAML"|"USERPOOL",
#'         SendEmailNotification = TRUE|FALSE
#'       ),
#'       ErrorCode = "STACK_NOT_FOUND"|"USER_NAME_NOT_FOUND"|"DIRECTORY_NOT_FOUND"|"INTERNAL_ERROR",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_associate_user_stack(
#'   UserStackAssociations = list(
#'     list(
#'       StackName = "string",
#'       UserName = "string",
#'       AuthenticationType = "API"|"SAML"|"USERPOOL",
#'       SendEmailNotification = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_batch_associate_user_stack
appstream_batch_associate_user_stack <- function(UserStackAssociations) {
  op <- new_operation(
    name = "BatchAssociateUserStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$batch_associate_user_stack_input(UserStackAssociations = UserStackAssociations)
  output <- .appstream$batch_associate_user_stack_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$batch_associate_user_stack <- appstream_batch_associate_user_stack

#' Disassociates the specified users from the specified stacks
#'
#' @description
#' Disassociates the specified users from the specified stacks.
#'
#' @usage
#' appstream_batch_disassociate_user_stack(UserStackAssociations)
#'
#' @param UserStackAssociations &#91;required&#93; The list of UserStackAssociation objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   errors = list(
#'     list(
#'       UserStackAssociation = list(
#'         StackName = "string",
#'         UserName = "string",
#'         AuthenticationType = "API"|"SAML"|"USERPOOL",
#'         SendEmailNotification = TRUE|FALSE
#'       ),
#'       ErrorCode = "STACK_NOT_FOUND"|"USER_NAME_NOT_FOUND"|"DIRECTORY_NOT_FOUND"|"INTERNAL_ERROR",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_disassociate_user_stack(
#'   UserStackAssociations = list(
#'     list(
#'       StackName = "string",
#'       UserName = "string",
#'       AuthenticationType = "API"|"SAML"|"USERPOOL",
#'       SendEmailNotification = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_batch_disassociate_user_stack
appstream_batch_disassociate_user_stack <- function(UserStackAssociations) {
  op <- new_operation(
    name = "BatchDisassociateUserStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$batch_disassociate_user_stack_input(UserStackAssociations = UserStackAssociations)
  output <- .appstream$batch_disassociate_user_stack_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$batch_disassociate_user_stack <- appstream_batch_disassociate_user_stack

#' Copies the image within the same region or to a new region within the
#' same AWS account
#'
#' @description
#' Copies the image within the same region or to a new region within the
#' same AWS account. Note that any tags you added to the image will not be
#' copied.
#'
#' @usage
#' appstream_copy_image(SourceImageName, DestinationImageName,
#'   DestinationRegion, DestinationImageDescription)
#'
#' @param SourceImageName &#91;required&#93; The name of the image to copy.
#' @param DestinationImageName &#91;required&#93; The name that the image will have when it is copied to the destination.
#' @param DestinationRegion &#91;required&#93; The destination region to which the image will be copied. This parameter
#' is required, even if you are copying an image within the same region.
#' @param DestinationImageDescription The description that the image will have when it is copied to the
#' destination.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DestinationImageName = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$copy_image(
#'   SourceImageName = "string",
#'   DestinationImageName = "string",
#'   DestinationRegion = "string",
#'   DestinationImageDescription = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_copy_image
appstream_copy_image <- function(SourceImageName, DestinationImageName, DestinationRegion, DestinationImageDescription = NULL) {
  op <- new_operation(
    name = "CopyImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$copy_image_input(SourceImageName = SourceImageName, DestinationImageName = DestinationImageName, DestinationRegion = DestinationRegion, DestinationImageDescription = DestinationImageDescription)
  output <- .appstream$copy_image_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$copy_image <- appstream_copy_image

#' Creates a Directory Config object in AppStream 2
#'
#' @description
#' Creates a Directory Config object in AppStream 2.0. This object includes
#' the configuration information required to join fleets and image builders
#' to Microsoft Active Directory domains.
#'
#' @usage
#' appstream_create_directory_config(DirectoryName,
#'   OrganizationalUnitDistinguishedNames, ServiceAccountCredentials)
#'
#' @param DirectoryName &#91;required&#93; The fully qualified name of the directory (for example,
#' corp.example.com).
#' @param OrganizationalUnitDistinguishedNames &#91;required&#93; The distinguished names of the organizational units for computer
#' accounts.
#' @param ServiceAccountCredentials The credentials for the service account used by the fleet or image
#' builder to connect to the directory.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DirectoryConfig = list(
#'     DirectoryName = "string",
#'     OrganizationalUnitDistinguishedNames = list(
#'       "string"
#'     ),
#'     ServiceAccountCredentials = list(
#'       AccountName = "string",
#'       AccountPassword = "string"
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_directory_config(
#'   DirectoryName = "string",
#'   OrganizationalUnitDistinguishedNames = list(
#'     "string"
#'   ),
#'   ServiceAccountCredentials = list(
#'     AccountName = "string",
#'     AccountPassword = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_directory_config
appstream_create_directory_config <- function(DirectoryName, OrganizationalUnitDistinguishedNames, ServiceAccountCredentials = NULL) {
  op <- new_operation(
    name = "CreateDirectoryConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_directory_config_input(DirectoryName = DirectoryName, OrganizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNames, ServiceAccountCredentials = ServiceAccountCredentials)
  output <- .appstream$create_directory_config_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_directory_config <- appstream_create_directory_config

#' Creates a fleet
#'
#' @description
#' Creates a fleet. A fleet consists of streaming instances that run a
#' specified image.
#'
#' @usage
#' appstream_create_fleet(Name, ImageName, ImageArn, InstanceType,
#'   FleetType, ComputeCapacity, VpcConfig, MaxUserDurationInSeconds,
#'   DisconnectTimeoutInSeconds, Description, DisplayName,
#'   EnableDefaultInternetAccess, DomainJoinInfo, Tags,
#'   IdleDisconnectTimeoutInSeconds, IamRoleArn, StreamView)
#'
#' @param Name &#91;required&#93; A unique name for the fleet.
#' @param ImageName The name of the image used to create the fleet.
#' @param ImageArn The ARN of the public, private, or shared image to use.
#' @param InstanceType &#91;required&#93; The instance type to use when launching fleet instances. The following
#' instance types are available:
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.compute.large
#' 
#' -   stream.compute.xlarge
#' 
#' -   stream.compute.2xlarge
#' 
#' -   stream.compute.4xlarge
#' 
#' -   stream.compute.8xlarge
#' 
#' -   stream.memory.large
#' 
#' -   stream.memory.xlarge
#' 
#' -   stream.memory.2xlarge
#' 
#' -   stream.memory.4xlarge
#' 
#' -   stream.memory.8xlarge
#' 
#' -   stream.memory.z1d.large
#' 
#' -   stream.memory.z1d.xlarge
#' 
#' -   stream.memory.z1d.2xlarge
#' 
#' -   stream.memory.z1d.3xlarge
#' 
#' -   stream.memory.z1d.6xlarge
#' 
#' -   stream.memory.z1d.12xlarge
#' 
#' -   stream.graphics-design.large
#' 
#' -   stream.graphics-design.xlarge
#' 
#' -   stream.graphics-design.2xlarge
#' 
#' -   stream.graphics-design.4xlarge
#' 
#' -   stream.graphics-desktop.2xlarge
#' 
#' -   stream.graphics.g4dn.xlarge
#' 
#' -   stream.graphics.g4dn.2xlarge
#' 
#' -   stream.graphics.g4dn.4xlarge
#' 
#' -   stream.graphics.g4dn.8xlarge
#' 
#' -   stream.graphics.g4dn.12xlarge
#' 
#' -   stream.graphics.g4dn.16xlarge
#' 
#' -   stream.graphics-pro.4xlarge
#' 
#' -   stream.graphics-pro.8xlarge
#' 
#' -   stream.graphics-pro.16xlarge
#' @param FleetType The fleet type.
#' 
#' ### ALWAYS_ON
#' 
#' Provides users with instant-on access to their apps. You are charged for
#' all running instances in your fleet, even if no users are streaming
#' apps.
#' 
#' ### ON_DEMAND
#' 
#' Provide users with access to applications after they connect, which
#' takes one to two minutes. You are charged for instance streaming when
#' users are connected and a small hourly fee for instances that are not
#' streaming apps.
#' @param ComputeCapacity &#91;required&#93; The desired capacity for the fleet.
#' @param VpcConfig The VPC configuration for the fleet.
#' @param MaxUserDurationInSeconds The maximum amount of time that a streaming session can remain active,
#' in seconds. If users are still connected to a streaming instance five
#' minutes before this limit is reached, they are prompted to save any open
#' documents before being disconnected. After this time elapses, the
#' instance is terminated and replaced by a new instance.
#' 
#' Specify a value between 600 and 360000.
#' @param DisconnectTimeoutInSeconds The amount of time that a streaming session remains active after users
#' disconnect. If users try to reconnect to the streaming session after a
#' disconnection or network interruption within this time interval, they
#' are connected to their previous session. Otherwise, they are connected
#' to a new session with a new streaming instance.
#' 
#' Specify a value between 60 and 360000.
#' @param Description The description to display.
#' @param DisplayName The fleet name to display.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the fleet.
#' @param DomainJoinInfo The name of the directory and organizational unit (OU) to use to join
#' the fleet to a Microsoft Active Directory domain.
#' @param Tags The tags to associate with the fleet. A tag is a key-value pair, and the
#' value is optional. For example, Environment=Test. If you do not specify
#' a value, Environment=.
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' For more information, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param IdleDisconnectTimeoutInSeconds The amount of time that users can be idle (inactive) before they are
#' disconnected from their streaming session and the
#' `DisconnectTimeoutInSeconds` time interval begins. Users are notified
#' before they are disconnected due to inactivity. If they try to reconnect
#' to the streaming session before the time interval specified in
#' `DisconnectTimeoutInSeconds` elapses, they are connected to their
#' previous session. Users are considered idle when they stop providing
#' keyboard or mouse input during their streaming session. File uploads and
#' downloads, audio in, audio out, and pixels changing do not qualify as
#' user activity. If users continue to be idle after the time interval in
#' `IdleDisconnectTimeoutInSeconds` elapses, they are disconnected.
#' 
#' To prevent users from being disconnected due to inactivity, specify a
#' value of 0. Otherwise, specify a value between 60 and 3600. The default
#' value is 0.
#' 
#' If you enable this feature, we recommend that you specify a value that
#' corresponds exactly to a whole number of minutes (for example, 60, 120,
#' and 180). If you don't do this, the value is rounded to the nearest
#' minute. For example, if you specify a value of 70, users are
#' disconnected after 1 minute of inactivity. If you specify a value that
#' is at the midpoint between two different minutes, the value is rounded
#' up. For example, if you specify a value of 90, users are disconnected
#' after 2 minutes of inactivity.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
#' assume a role, a fleet instance calls the AWS Security Token Service
#' (STS) `AssumeRole` API operation and passes the ARN of the role to use.
#' The operation creates a new session with temporary credentials.
#' AppStream 2.0 retrieves the temporary credentials and creates the
#' **appstream_machine_role** credential profile on the instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param StreamView The AppStream 2.0 view that is displayed to your users when they stream
#' from the fleet. When `APP` is specified, only the windows of
#' applications opened by users display. When `DESKTOP` is specified, the
#' standard desktop that is provided by the operating system displays.
#' 
#' The default value is `APP`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Fleet = list(
#'     Arn = "string",
#'     Name = "string",
#'     DisplayName = "string",
#'     Description = "string",
#'     ImageName = "string",
#'     ImageArn = "string",
#'     InstanceType = "string",
#'     FleetType = "ALWAYS_ON"|"ON_DEMAND",
#'     ComputeCapacityStatus = list(
#'       Desired = 123,
#'       Running = 123,
#'       InUse = 123,
#'       Available = 123
#'     ),
#'     MaxUserDurationInSeconds = 123,
#'     DisconnectTimeoutInSeconds = 123,
#'     State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED",
#'     VpcConfig = list(
#'       SubnetIds = list(
#'         "string"
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FleetErrors = list(
#'       list(
#'         ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string"
#'       )
#'     ),
#'     EnableDefaultInternetAccess = TRUE|FALSE,
#'     DomainJoinInfo = list(
#'       DirectoryName = "string",
#'       OrganizationalUnitDistinguishedName = "string"
#'     ),
#'     IdleDisconnectTimeoutInSeconds = 123,
#'     IamRoleArn = "string",
#'     StreamView = "APP"|"DESKTOP"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_fleet(
#'   Name = "string",
#'   ImageName = "string",
#'   ImageArn = "string",
#'   InstanceType = "string",
#'   FleetType = "ALWAYS_ON"|"ON_DEMAND",
#'   ComputeCapacity = list(
#'     DesiredInstances = 123
#'   ),
#'   VpcConfig = list(
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   MaxUserDurationInSeconds = 123,
#'   DisconnectTimeoutInSeconds = 123,
#'   Description = "string",
#'   DisplayName = "string",
#'   EnableDefaultInternetAccess = TRUE|FALSE,
#'   DomainJoinInfo = list(
#'     DirectoryName = "string",
#'     OrganizationalUnitDistinguishedName = "string"
#'   ),
#'   Tags = list(
#'     "string"
#'   ),
#'   IdleDisconnectTimeoutInSeconds = 123,
#'   IamRoleArn = "string",
#'   StreamView = "APP"|"DESKTOP"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_fleet
appstream_create_fleet <- function(Name, ImageName = NULL, ImageArn = NULL, InstanceType, FleetType = NULL, ComputeCapacity, VpcConfig = NULL, MaxUserDurationInSeconds = NULL, DisconnectTimeoutInSeconds = NULL, Description = NULL, DisplayName = NULL, EnableDefaultInternetAccess = NULL, DomainJoinInfo = NULL, Tags = NULL, IdleDisconnectTimeoutInSeconds = NULL, IamRoleArn = NULL, StreamView = NULL) {
  op <- new_operation(
    name = "CreateFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_fleet_input(Name = Name, ImageName = ImageName, ImageArn = ImageArn, InstanceType = InstanceType, FleetType = FleetType, ComputeCapacity = ComputeCapacity, VpcConfig = VpcConfig, MaxUserDurationInSeconds = MaxUserDurationInSeconds, DisconnectTimeoutInSeconds = DisconnectTimeoutInSeconds, Description = Description, DisplayName = DisplayName, EnableDefaultInternetAccess = EnableDefaultInternetAccess, DomainJoinInfo = DomainJoinInfo, Tags = Tags, IdleDisconnectTimeoutInSeconds = IdleDisconnectTimeoutInSeconds, IamRoleArn = IamRoleArn, StreamView = StreamView)
  output <- .appstream$create_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_fleet <- appstream_create_fleet

#' Creates an image builder
#'
#' @description
#' Creates an image builder. An image builder is a virtual machine that is
#' used to create an image.
#' 
#' The initial state of the builder is `PENDING`. When it is ready, the
#' state is `RUNNING`.
#'
#' @usage
#' appstream_create_image_builder(Name, ImageName, ImageArn, InstanceType,
#'   Description, DisplayName, VpcConfig, IamRoleArn,
#'   EnableDefaultInternetAccess, DomainJoinInfo, AppstreamAgentVersion,
#'   Tags, AccessEndpoints)
#'
#' @param Name &#91;required&#93; A unique name for the image builder.
#' @param ImageName The name of the image used to create the image builder.
#' @param ImageArn The ARN of the public, private, or shared image to use.
#' @param InstanceType &#91;required&#93; The instance type to use when launching the image builder. The following
#' instance types are available:
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.compute.large
#' 
#' -   stream.compute.xlarge
#' 
#' -   stream.compute.2xlarge
#' 
#' -   stream.compute.4xlarge
#' 
#' -   stream.compute.8xlarge
#' 
#' -   stream.memory.large
#' 
#' -   stream.memory.xlarge
#' 
#' -   stream.memory.2xlarge
#' 
#' -   stream.memory.4xlarge
#' 
#' -   stream.memory.8xlarge
#' 
#' -   stream.memory.z1d.large
#' 
#' -   stream.memory.z1d.xlarge
#' 
#' -   stream.memory.z1d.2xlarge
#' 
#' -   stream.memory.z1d.3xlarge
#' 
#' -   stream.memory.z1d.6xlarge
#' 
#' -   stream.memory.z1d.12xlarge
#' 
#' -   stream.graphics-design.large
#' 
#' -   stream.graphics-design.xlarge
#' 
#' -   stream.graphics-design.2xlarge
#' 
#' -   stream.graphics-design.4xlarge
#' 
#' -   stream.graphics-desktop.2xlarge
#' 
#' -   stream.graphics.g4dn.xlarge
#' 
#' -   stream.graphics.g4dn.2xlarge
#' 
#' -   stream.graphics.g4dn.4xlarge
#' 
#' -   stream.graphics.g4dn.8xlarge
#' 
#' -   stream.graphics.g4dn.12xlarge
#' 
#' -   stream.graphics.g4dn.16xlarge
#' 
#' -   stream.graphics-pro.4xlarge
#' 
#' -   stream.graphics-pro.8xlarge
#' 
#' -   stream.graphics-pro.16xlarge
#' @param Description The description to display.
#' @param DisplayName The image builder name to display.
#' @param VpcConfig The VPC configuration for the image builder. You can specify only one
#' subnet.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the image
#' builder. To assume a role, the image builder calls the AWS Security
#' Token Service (STS) `AssumeRole` API operation and passes the ARN of the
#' role to use. The operation creates a new session with temporary
#' credentials. AppStream 2.0 retrieves the temporary credentials and
#' creates the **appstream_machine_role** credential profile on the
#' instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the image builder.
#' @param DomainJoinInfo The name of the directory and organizational unit (OU) to use to join
#' the image builder to a Microsoft Active Directory domain.
#' @param AppstreamAgentVersion The version of the AppStream 2.0 agent to use for this image builder. To
#' use the latest version of the AppStream 2.0 agent, specify \[LATEST\].
#' @param Tags The tags to associate with the image builder. A tag is a key-value pair,
#' and the value is optional. For example, Environment=Test. If you do not
#' specify a value, Environment=.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects.
#' Administrators can connect to the image builder only through the
#' specified endpoints.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageBuilder = list(
#'     Name = "string",
#'     Arn = "string",
#'     ImageArn = "string",
#'     Description = "string",
#'     DisplayName = "string",
#'     VpcConfig = list(
#'       SubnetIds = list(
#'         "string"
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     InstanceType = "string",
#'     Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
#'     IamRoleArn = "string",
#'     State = "PENDING"|"UPDATING_AGENT"|"RUNNING"|"STOPPING"|"STOPPED"|"REBOOTING"|"SNAPSHOTTING"|"DELETING"|"FAILED",
#'     StateChangeReason = list(
#'       Code = "INTERNAL_ERROR"|"IMAGE_UNAVAILABLE",
#'       Message = "string"
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EnableDefaultInternetAccess = TRUE|FALSE,
#'     DomainJoinInfo = list(
#'       DirectoryName = "string",
#'       OrganizationalUnitDistinguishedName = "string"
#'     ),
#'     NetworkAccessConfiguration = list(
#'       EniPrivateIpAddress = "string",
#'       EniId = "string"
#'     ),
#'     ImageBuilderErrors = list(
#'       list(
#'         ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string",
#'         ErrorTimestamp = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     AppstreamAgentVersion = "string",
#'     AccessEndpoints = list(
#'       list(
#'         EndpointType = "STREAMING",
#'         VpceId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_image_builder(
#'   Name = "string",
#'   ImageName = "string",
#'   ImageArn = "string",
#'   InstanceType = "string",
#'   Description = "string",
#'   DisplayName = "string",
#'   VpcConfig = list(
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   IamRoleArn = "string",
#'   EnableDefaultInternetAccess = TRUE|FALSE,
#'   DomainJoinInfo = list(
#'     DirectoryName = "string",
#'     OrganizationalUnitDistinguishedName = "string"
#'   ),
#'   AppstreamAgentVersion = "string",
#'   Tags = list(
#'     "string"
#'   ),
#'   AccessEndpoints = list(
#'     list(
#'       EndpointType = "STREAMING",
#'       VpceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_image_builder
appstream_create_image_builder <- function(Name, ImageName = NULL, ImageArn = NULL, InstanceType, Description = NULL, DisplayName = NULL, VpcConfig = NULL, IamRoleArn = NULL, EnableDefaultInternetAccess = NULL, DomainJoinInfo = NULL, AppstreamAgentVersion = NULL, Tags = NULL, AccessEndpoints = NULL) {
  op <- new_operation(
    name = "CreateImageBuilder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_image_builder_input(Name = Name, ImageName = ImageName, ImageArn = ImageArn, InstanceType = InstanceType, Description = Description, DisplayName = DisplayName, VpcConfig = VpcConfig, IamRoleArn = IamRoleArn, EnableDefaultInternetAccess = EnableDefaultInternetAccess, DomainJoinInfo = DomainJoinInfo, AppstreamAgentVersion = AppstreamAgentVersion, Tags = Tags, AccessEndpoints = AccessEndpoints)
  output <- .appstream$create_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_image_builder <- appstream_create_image_builder

#' Creates a URL to start an image builder streaming session
#'
#' @description
#' Creates a URL to start an image builder streaming session.
#'
#' @usage
#' appstream_create_image_builder_streaming_url(Name, Validity)
#'
#' @param Name &#91;required&#93; The name of the image builder.
#' @param Validity The time that the streaming URL will be valid, in seconds. Specify a
#' value between 1 and 604800 seconds. The default is 3600 seconds.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingURL = "string",
#'   Expires = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_image_builder_streaming_url(
#'   Name = "string",
#'   Validity = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_image_builder_streaming_url
appstream_create_image_builder_streaming_url <- function(Name, Validity = NULL) {
  op <- new_operation(
    name = "CreateImageBuilderStreamingURL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_image_builder_streaming_url_input(Name = Name, Validity = Validity)
  output <- .appstream$create_image_builder_streaming_url_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_image_builder_streaming_url <- appstream_create_image_builder_streaming_url

#' Creates a stack to start streaming applications to users
#'
#' @description
#' Creates a stack to start streaming applications to users. A stack
#' consists of an associated fleet, user access policies, and storage
#' configurations.
#'
#' @usage
#' appstream_create_stack(Name, Description, DisplayName,
#'   StorageConnectors, RedirectURL, FeedbackURL, UserSettings,
#'   ApplicationSettings, Tags, AccessEndpoints, EmbedHostDomains)
#'
#' @param Name &#91;required&#93; The name of the stack.
#' @param Description The description to display.
#' @param DisplayName The stack name to display.
#' @param StorageConnectors The storage connectors to enable.
#' @param RedirectURL The URL that users are redirected to after their streaming session ends.
#' @param FeedbackURL The URL that users are redirected to after they click the Send Feedback
#' link. If no URL is specified, no Send Feedback link is displayed.
#' @param UserSettings The actions that are enabled or disabled for users during their
#' streaming sessions. By default, these actions are enabled.
#' @param ApplicationSettings The persistent application settings for users of a stack. When these
#' settings are enabled, changes that users make to applications and
#' Windows settings are automatically saved after each session and applied
#' to the next session.
#' @param Tags The tags to associate with the stack. A tag is a key-value pair, and the
#' value is optional. For example, Environment=Test. If you do not specify
#' a value, Environment=.
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects. Users
#' of the stack can connect to AppStream 2.0 only through the specified
#' endpoints.
#' @param EmbedHostDomains The domains where AppStream 2.0 streaming sessions can be embedded in an
#' iframe. You must approve the domains that you want to host embedded
#' AppStream 2.0 streaming sessions.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Stack = list(
#'     Arn = "string",
#'     Name = "string",
#'     Description = "string",
#'     DisplayName = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StorageConnectors = list(
#'       list(
#'         ConnectorType = "HOMEFOLDERS"|"GOOGLE_DRIVE"|"ONE_DRIVE",
#'         ResourceIdentifier = "string",
#'         Domains = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     RedirectURL = "string",
#'     FeedbackURL = "string",
#'     StackErrors = list(
#'       list(
#'         ErrorCode = "STORAGE_CONNECTOR_ERROR"|"INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string"
#'       )
#'     ),
#'     UserSettings = list(
#'       list(
#'         Action = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE"|"CLIPBOARD_COPY_TO_LOCAL_DEVICE"|"FILE_UPLOAD"|"FILE_DOWNLOAD"|"PRINTING_TO_LOCAL_DEVICE",
#'         Permission = "ENABLED"|"DISABLED"
#'       )
#'     ),
#'     ApplicationSettings = list(
#'       Enabled = TRUE|FALSE,
#'       SettingsGroup = "string",
#'       S3BucketName = "string"
#'     ),
#'     AccessEndpoints = list(
#'       list(
#'         EndpointType = "STREAMING",
#'         VpceId = "string"
#'       )
#'     ),
#'     EmbedHostDomains = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_stack(
#'   Name = "string",
#'   Description = "string",
#'   DisplayName = "string",
#'   StorageConnectors = list(
#'     list(
#'       ConnectorType = "HOMEFOLDERS"|"GOOGLE_DRIVE"|"ONE_DRIVE",
#'       ResourceIdentifier = "string",
#'       Domains = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   RedirectURL = "string",
#'   FeedbackURL = "string",
#'   UserSettings = list(
#'     list(
#'       Action = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE"|"CLIPBOARD_COPY_TO_LOCAL_DEVICE"|"FILE_UPLOAD"|"FILE_DOWNLOAD"|"PRINTING_TO_LOCAL_DEVICE",
#'       Permission = "ENABLED"|"DISABLED"
#'     )
#'   ),
#'   ApplicationSettings = list(
#'     Enabled = TRUE|FALSE,
#'     SettingsGroup = "string"
#'   ),
#'   Tags = list(
#'     "string"
#'   ),
#'   AccessEndpoints = list(
#'     list(
#'       EndpointType = "STREAMING",
#'       VpceId = "string"
#'     )
#'   ),
#'   EmbedHostDomains = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_stack
appstream_create_stack <- function(Name, Description = NULL, DisplayName = NULL, StorageConnectors = NULL, RedirectURL = NULL, FeedbackURL = NULL, UserSettings = NULL, ApplicationSettings = NULL, Tags = NULL, AccessEndpoints = NULL, EmbedHostDomains = NULL) {
  op <- new_operation(
    name = "CreateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_stack_input(Name = Name, Description = Description, DisplayName = DisplayName, StorageConnectors = StorageConnectors, RedirectURL = RedirectURL, FeedbackURL = FeedbackURL, UserSettings = UserSettings, ApplicationSettings = ApplicationSettings, Tags = Tags, AccessEndpoints = AccessEndpoints, EmbedHostDomains = EmbedHostDomains)
  output <- .appstream$create_stack_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_stack <- appstream_create_stack

#' Creates a temporary URL to start an AppStream 2
#'
#' @description
#' Creates a temporary URL to start an AppStream 2.0 streaming session for
#' the specified user. A streaming URL enables application streaming to be
#' tested without user setup.
#'
#' @usage
#' appstream_create_streaming_url(StackName, FleetName, UserId,
#'   ApplicationId, Validity, SessionContext)
#'
#' @param StackName &#91;required&#93; The name of the stack.
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param UserId &#91;required&#93; The identifier of the user.
#' @param ApplicationId The name of the application to launch after the session starts. This is
#' the name that you specified as **Name** in the Image Assistant.
#' @param Validity The time that the streaming URL will be valid, in seconds. Specify a
#' value between 1 and 604800 seconds. The default is 60 seconds.
#' @param SessionContext The session context. For more information, see [Session
#' Context](https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StreamingURL = "string",
#'   Expires = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_streaming_url(
#'   StackName = "string",
#'   FleetName = "string",
#'   UserId = "string",
#'   ApplicationId = "string",
#'   Validity = 123,
#'   SessionContext = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_streaming_url
appstream_create_streaming_url <- function(StackName, FleetName, UserId, ApplicationId = NULL, Validity = NULL, SessionContext = NULL) {
  op <- new_operation(
    name = "CreateStreamingURL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_streaming_url_input(StackName = StackName, FleetName = FleetName, UserId = UserId, ApplicationId = ApplicationId, Validity = Validity, SessionContext = SessionContext)
  output <- .appstream$create_streaming_url_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_streaming_url <- appstream_create_streaming_url

#' Creates a usage report subscription
#'
#' @description
#' Creates a usage report subscription. Usage reports are generated daily.
#'
#' @usage
#' appstream_create_usage_report_subscription()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   S3BucketName = "string",
#'   Schedule = "DAILY"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_usage_report_subscription()
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_usage_report_subscription
appstream_create_usage_report_subscription <- function() {
  op <- new_operation(
    name = "CreateUsageReportSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_usage_report_subscription_input()
  output <- .appstream$create_usage_report_subscription_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_usage_report_subscription <- appstream_create_usage_report_subscription

#' Creates a new user in the user pool
#'
#' @description
#' Creates a new user in the user pool.
#'
#' @usage
#' appstream_create_user(UserName, MessageAction, FirstName, LastName,
#'   AuthenticationType)
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive. During login, if they specify
#' an email address that doesn't use the same capitalization as the email
#' address specified when their user pool account was created, a "user does
#' not exist" error message displays.
#' @param MessageAction The action to take for the welcome email that is sent to a user after
#' the user is created in the user pool. If you specify SUPPRESS, no email
#' is sent. If you specify RESEND, do not specify the first name or last
#' name of the user. If the value is null, the email is sent.
#' 
#' The temporary password in the welcome email is valid for only 7 days. If
#' users don’t set their passwords within 7 days, you must send them a new
#' welcome email.
#' @param FirstName The first name, or given name, of the user.
#' @param LastName The last name, or surname, of the user.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_user(
#'   UserName = "string",
#'   MessageAction = "SUPPRESS"|"RESEND",
#'   FirstName = "string",
#'   LastName = "string",
#'   AuthenticationType = "API"|"SAML"|"USERPOOL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_create_user
appstream_create_user <- function(UserName, MessageAction = NULL, FirstName = NULL, LastName = NULL, AuthenticationType) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$create_user_input(UserName = UserName, MessageAction = MessageAction, FirstName = FirstName, LastName = LastName, AuthenticationType = AuthenticationType)
  output <- .appstream$create_user_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_user <- appstream_create_user

#' Deletes the specified Directory Config object from AppStream 2
#'
#' @description
#' Deletes the specified Directory Config object from AppStream 2.0. This
#' object includes the information required to join streaming instances to
#' an Active Directory domain.
#'
#' @usage
#' appstream_delete_directory_config(DirectoryName)
#'
#' @param DirectoryName &#91;required&#93; The name of the directory configuration.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_directory_config(
#'   DirectoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_directory_config
appstream_delete_directory_config <- function(DirectoryName) {
  op <- new_operation(
    name = "DeleteDirectoryConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_directory_config_input(DirectoryName = DirectoryName)
  output <- .appstream$delete_directory_config_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_directory_config <- appstream_delete_directory_config

#' Deletes the specified fleet
#'
#' @description
#' Deletes the specified fleet.
#'
#' @usage
#' appstream_delete_fleet(Name)
#'
#' @param Name &#91;required&#93; The name of the fleet.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_fleet(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_fleet
appstream_delete_fleet <- function(Name) {
  op <- new_operation(
    name = "DeleteFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_fleet_input(Name = Name)
  output <- .appstream$delete_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_fleet <- appstream_delete_fleet

#' Deletes the specified image
#'
#' @description
#' Deletes the specified image. You cannot delete an image when it is in
#' use. After you delete an image, you cannot provision new capacity using
#' the image.
#'
#' @usage
#' appstream_delete_image(Name)
#'
#' @param Name &#91;required&#93; The name of the image.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Image = list(
#'     Name = "string",
#'     Arn = "string",
#'     BaseImageArn = "string",
#'     DisplayName = "string",
#'     State = "PENDING"|"AVAILABLE"|"FAILED"|"COPYING"|"DELETING",
#'     Visibility = "PUBLIC"|"PRIVATE"|"SHARED",
#'     ImageBuilderSupported = TRUE|FALSE,
#'     ImageBuilderName = "string",
#'     Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
#'     Description = "string",
#'     StateChangeReason = list(
#'       Code = "INTERNAL_ERROR"|"IMAGE_BUILDER_NOT_AVAILABLE"|"IMAGE_COPY_FAILURE",
#'       Message = "string"
#'     ),
#'     Applications = list(
#'       list(
#'         Name = "string",
#'         DisplayName = "string",
#'         IconURL = "string",
#'         LaunchPath = "string",
#'         LaunchParameters = "string",
#'         Enabled = TRUE|FALSE,
#'         Metadata = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     PublicBaseImageReleasedDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     AppstreamAgentVersion = "string",
#'     ImagePermissions = list(
#'       allowFleet = TRUE|FALSE,
#'       allowImageBuilder = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_image(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_image
appstream_delete_image <- function(Name) {
  op <- new_operation(
    name = "DeleteImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_image_input(Name = Name)
  output <- .appstream$delete_image_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_image <- appstream_delete_image

#' Deletes the specified image builder and releases the capacity
#'
#' @description
#' Deletes the specified image builder and releases the capacity.
#'
#' @usage
#' appstream_delete_image_builder(Name)
#'
#' @param Name &#91;required&#93; The name of the image builder.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageBuilder = list(
#'     Name = "string",
#'     Arn = "string",
#'     ImageArn = "string",
#'     Description = "string",
#'     DisplayName = "string",
#'     VpcConfig = list(
#'       SubnetIds = list(
#'         "string"
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     InstanceType = "string",
#'     Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
#'     IamRoleArn = "string",
#'     State = "PENDING"|"UPDATING_AGENT"|"RUNNING"|"STOPPING"|"STOPPED"|"REBOOTING"|"SNAPSHOTTING"|"DELETING"|"FAILED",
#'     StateChangeReason = list(
#'       Code = "INTERNAL_ERROR"|"IMAGE_UNAVAILABLE",
#'       Message = "string"
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EnableDefaultInternetAccess = TRUE|FALSE,
#'     DomainJoinInfo = list(
#'       DirectoryName = "string",
#'       OrganizationalUnitDistinguishedName = "string"
#'     ),
#'     NetworkAccessConfiguration = list(
#'       EniPrivateIpAddress = "string",
#'       EniId = "string"
#'     ),
#'     ImageBuilderErrors = list(
#'       list(
#'         ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string",
#'         ErrorTimestamp = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     AppstreamAgentVersion = "string",
#'     AccessEndpoints = list(
#'       list(
#'         EndpointType = "STREAMING",
#'         VpceId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_image_builder(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_image_builder
appstream_delete_image_builder <- function(Name) {
  op <- new_operation(
    name = "DeleteImageBuilder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_image_builder_input(Name = Name)
  output <- .appstream$delete_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_image_builder <- appstream_delete_image_builder

#' Deletes permissions for the specified private image
#'
#' @description
#' Deletes permissions for the specified private image. After you delete
#' permissions for an image, AWS accounts to which you previously granted
#' these permissions can no longer use the image.
#'
#' @usage
#' appstream_delete_image_permissions(Name, SharedAccountId)
#'
#' @param Name &#91;required&#93; The name of the private image.
#' @param SharedAccountId &#91;required&#93; The 12-digit identifier of the AWS account for which to delete image
#' permissions.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_image_permissions(
#'   Name = "string",
#'   SharedAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_image_permissions
appstream_delete_image_permissions <- function(Name, SharedAccountId) {
  op <- new_operation(
    name = "DeleteImagePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_image_permissions_input(Name = Name, SharedAccountId = SharedAccountId)
  output <- .appstream$delete_image_permissions_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_image_permissions <- appstream_delete_image_permissions

#' Deletes the specified stack
#'
#' @description
#' Deletes the specified stack. After the stack is deleted, the application
#' streaming environment provided by the stack is no longer available to
#' users. Also, any reservations made for application streaming sessions
#' for the stack are released.
#'
#' @usage
#' appstream_delete_stack(Name)
#'
#' @param Name &#91;required&#93; The name of the stack.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_stack(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_stack
appstream_delete_stack <- function(Name) {
  op <- new_operation(
    name = "DeleteStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_stack_input(Name = Name)
  output <- .appstream$delete_stack_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_stack <- appstream_delete_stack

#' Disables usage report generation
#'
#' @description
#' Disables usage report generation.
#'
#' @usage
#' appstream_delete_usage_report_subscription()
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_usage_report_subscription()
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_usage_report_subscription
appstream_delete_usage_report_subscription <- function() {
  op <- new_operation(
    name = "DeleteUsageReportSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_usage_report_subscription_input()
  output <- .appstream$delete_usage_report_subscription_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_usage_report_subscription <- appstream_delete_usage_report_subscription

#' Deletes a user from the user pool
#'
#' @description
#' Deletes a user from the user pool.
#'
#' @usage
#' appstream_delete_user(UserName, AuthenticationType)
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user(
#'   UserName = "string",
#'   AuthenticationType = "API"|"SAML"|"USERPOOL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_delete_user
appstream_delete_user <- function(UserName, AuthenticationType) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$delete_user_input(UserName = UserName, AuthenticationType = AuthenticationType)
  output <- .appstream$delete_user_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_user <- appstream_delete_user

#' Retrieves a list that describes one or more specified Directory Config
#' objects for AppStream 2
#'
#' @description
#' Retrieves a list that describes one or more specified Directory Config
#' objects for AppStream 2.0, if the names for these objects are provided.
#' Otherwise, all Directory Config objects in the account are described.
#' These objects include the configuration information required to join
#' fleets and image builders to Microsoft Active Directory domains.
#' 
#' Although the response syntax in this topic includes the account
#' password, this password is not returned in the actual response.
#'
#' @usage
#' appstream_describe_directory_configs(DirectoryNames, MaxResults,
#'   NextToken)
#'
#' @param DirectoryNames The directory names.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DirectoryConfigs = list(
#'     list(
#'       DirectoryName = "string",
#'       OrganizationalUnitDistinguishedNames = list(
#'         "string"
#'       ),
#'       ServiceAccountCredentials = list(
#'         AccountName = "string",
#'         AccountPassword = "string"
#'       ),
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_directory_configs(
#'   DirectoryNames = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_directory_configs
appstream_describe_directory_configs <- function(DirectoryNames = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectoryConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_directory_configs_input(DirectoryNames = DirectoryNames, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_directory_configs_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_directory_configs <- appstream_describe_directory_configs

#' Retrieves a list that describes one or more specified fleets, if the
#' fleet names are provided
#'
#' @description
#' Retrieves a list that describes one or more specified fleets, if the
#' fleet names are provided. Otherwise, all fleets in the account are
#' described.
#'
#' @usage
#' appstream_describe_fleets(Names, NextToken)
#'
#' @param Names The names of the fleets to describe.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Fleets = list(
#'     list(
#'       Arn = "string",
#'       Name = "string",
#'       DisplayName = "string",
#'       Description = "string",
#'       ImageName = "string",
#'       ImageArn = "string",
#'       InstanceType = "string",
#'       FleetType = "ALWAYS_ON"|"ON_DEMAND",
#'       ComputeCapacityStatus = list(
#'         Desired = 123,
#'         Running = 123,
#'         InUse = 123,
#'         Available = 123
#'       ),
#'       MaxUserDurationInSeconds = 123,
#'       DisconnectTimeoutInSeconds = 123,
#'       State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED",
#'       VpcConfig = list(
#'         SubnetIds = list(
#'           "string"
#'         ),
#'         SecurityGroupIds = list(
#'           "string"
#'         )
#'       ),
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       FleetErrors = list(
#'         list(
#'           ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'           ErrorMessage = "string"
#'         )
#'       ),
#'       EnableDefaultInternetAccess = TRUE|FALSE,
#'       DomainJoinInfo = list(
#'         DirectoryName = "string",
#'         OrganizationalUnitDistinguishedName = "string"
#'       ),
#'       IdleDisconnectTimeoutInSeconds = 123,
#'       IamRoleArn = "string",
#'       StreamView = "APP"|"DESKTOP"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleets(
#'   Names = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_fleets
appstream_describe_fleets <- function(Names = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_fleets_input(Names = Names, NextToken = NextToken)
  output <- .appstream$describe_fleets_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_fleets <- appstream_describe_fleets

#' Retrieves a list that describes one or more specified image builders, if
#' the image builder names are provided
#'
#' @description
#' Retrieves a list that describes one or more specified image builders, if
#' the image builder names are provided. Otherwise, all image builders in
#' the account are described.
#'
#' @usage
#' appstream_describe_image_builders(Names, MaxResults, NextToken)
#'
#' @param Names The names of the image builders to describe.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageBuilders = list(
#'     list(
#'       Name = "string",
#'       Arn = "string",
#'       ImageArn = "string",
#'       Description = "string",
#'       DisplayName = "string",
#'       VpcConfig = list(
#'         SubnetIds = list(
#'           "string"
#'         ),
#'         SecurityGroupIds = list(
#'           "string"
#'         )
#'       ),
#'       InstanceType = "string",
#'       Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
#'       IamRoleArn = "string",
#'       State = "PENDING"|"UPDATING_AGENT"|"RUNNING"|"STOPPING"|"STOPPED"|"REBOOTING"|"SNAPSHOTTING"|"DELETING"|"FAILED",
#'       StateChangeReason = list(
#'         Code = "INTERNAL_ERROR"|"IMAGE_UNAVAILABLE",
#'         Message = "string"
#'       ),
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EnableDefaultInternetAccess = TRUE|FALSE,
#'       DomainJoinInfo = list(
#'         DirectoryName = "string",
#'         OrganizationalUnitDistinguishedName = "string"
#'       ),
#'       NetworkAccessConfiguration = list(
#'         EniPrivateIpAddress = "string",
#'         EniId = "string"
#'       ),
#'       ImageBuilderErrors = list(
#'         list(
#'           ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'           ErrorMessage = "string",
#'           ErrorTimestamp = as.POSIXct(
#'             "2015-01-01"
#'           )
#'         )
#'       ),
#'       AppstreamAgentVersion = "string",
#'       AccessEndpoints = list(
#'         list(
#'           EndpointType = "STREAMING",
#'           VpceId = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_image_builders(
#'   Names = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_image_builders
appstream_describe_image_builders <- function(Names = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImageBuilders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_image_builders_input(Names = Names, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_image_builders_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_image_builders <- appstream_describe_image_builders

#' Retrieves a list that describes the permissions for shared AWS account
#' IDs on a private image that you own
#'
#' @description
#' Retrieves a list that describes the permissions for shared AWS account
#' IDs on a private image that you own.
#'
#' @usage
#' appstream_describe_image_permissions(Name, MaxResults,
#'   SharedAwsAccountIds, NextToken)
#'
#' @param Name &#91;required&#93; The name of the private image for which to describe permissions. The
#' image must be one that you own.
#' @param MaxResults The maximum size of each page of results.
#' @param SharedAwsAccountIds The 12-digit identifier of one or more AWS accounts with which the image
#' is shared.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string",
#'   SharedImagePermissionsList = list(
#'     list(
#'       sharedAccountId = "string",
#'       imagePermissions = list(
#'         allowFleet = TRUE|FALSE,
#'         allowImageBuilder = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_image_permissions(
#'   Name = "string",
#'   MaxResults = 123,
#'   SharedAwsAccountIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_image_permissions
appstream_describe_image_permissions <- function(Name, MaxResults = NULL, SharedAwsAccountIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImagePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_image_permissions_input(Name = Name, MaxResults = MaxResults, SharedAwsAccountIds = SharedAwsAccountIds, NextToken = NextToken)
  output <- .appstream$describe_image_permissions_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_image_permissions <- appstream_describe_image_permissions

#' Retrieves a list that describes one or more specified images, if the
#' image names or image ARNs are provided
#'
#' @description
#' Retrieves a list that describes one or more specified images, if the
#' image names or image ARNs are provided. Otherwise, all images in the
#' account are described.
#'
#' @usage
#' appstream_describe_images(Names, Arns, Type, NextToken, MaxResults)
#'
#' @param Names The names of the public or private images to describe.
#' @param Arns The ARNs of the public, private, and shared images to describe.
#' @param Type The type of image (public, private, or shared) to describe.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum size of each page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Images = list(
#'     list(
#'       Name = "string",
#'       Arn = "string",
#'       BaseImageArn = "string",
#'       DisplayName = "string",
#'       State = "PENDING"|"AVAILABLE"|"FAILED"|"COPYING"|"DELETING",
#'       Visibility = "PUBLIC"|"PRIVATE"|"SHARED",
#'       ImageBuilderSupported = TRUE|FALSE,
#'       ImageBuilderName = "string",
#'       Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
#'       Description = "string",
#'       StateChangeReason = list(
#'         Code = "INTERNAL_ERROR"|"IMAGE_BUILDER_NOT_AVAILABLE"|"IMAGE_COPY_FAILURE",
#'         Message = "string"
#'       ),
#'       Applications = list(
#'         list(
#'           Name = "string",
#'           DisplayName = "string",
#'           IconURL = "string",
#'           LaunchPath = "string",
#'           LaunchParameters = "string",
#'           Enabled = TRUE|FALSE,
#'           Metadata = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       PublicBaseImageReleasedDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       AppstreamAgentVersion = "string",
#'       ImagePermissions = list(
#'         allowFleet = TRUE|FALSE,
#'         allowImageBuilder = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_images(
#'   Names = list(
#'     "string"
#'   ),
#'   Arns = list(
#'     "string"
#'   ),
#'   Type = "PUBLIC"|"PRIVATE"|"SHARED",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_images
appstream_describe_images <- function(Names = NULL, Arns = NULL, Type = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_images_input(Names = Names, Arns = Arns, Type = Type, NextToken = NextToken, MaxResults = MaxResults)
  output <- .appstream$describe_images_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_images <- appstream_describe_images

#' Retrieves a list that describes the streaming sessions for a specified
#' stack and fleet
#'
#' @description
#' Retrieves a list that describes the streaming sessions for a specified
#' stack and fleet. If a UserId is provided for the stack and fleet, only
#' streaming sessions for that user are described. If an authentication
#' type is not provided, the default is to authenticate users using a
#' streaming URL.
#'
#' @usage
#' appstream_describe_sessions(StackName, FleetName, UserId, NextToken,
#'   Limit, AuthenticationType)
#'
#' @param StackName &#91;required&#93; The name of the stack. This value is case-sensitive.
#' @param FleetName &#91;required&#93; The name of the fleet. This value is case-sensitive.
#' @param UserId The user identifier (ID). If you specify a user ID, you must also
#' specify the authentication type.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param Limit The size of each page of results. The default value is 20 and the
#' maximum value is 50.
#' @param AuthenticationType The authentication method. Specify `API` for a user authenticated using
#' a streaming URL or `SAML` for a SAML federated user. The default is to
#' authenticate users using a streaming URL.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Sessions = list(
#'     list(
#'       Id = "string",
#'       UserId = "string",
#'       StackName = "string",
#'       FleetName = "string",
#'       State = "ACTIVE"|"PENDING"|"EXPIRED",
#'       ConnectionState = "CONNECTED"|"NOT_CONNECTED",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       MaxExpirationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       AuthenticationType = "API"|"SAML"|"USERPOOL",
#'       NetworkAccessConfiguration = list(
#'         EniPrivateIpAddress = "string",
#'         EniId = "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_sessions(
#'   StackName = "string",
#'   FleetName = "string",
#'   UserId = "string",
#'   NextToken = "string",
#'   Limit = 123,
#'   AuthenticationType = "API"|"SAML"|"USERPOOL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_sessions
appstream_describe_sessions <- function(StackName, FleetName, UserId = NULL, NextToken = NULL, Limit = NULL, AuthenticationType = NULL) {
  op <- new_operation(
    name = "DescribeSessions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_sessions_input(StackName = StackName, FleetName = FleetName, UserId = UserId, NextToken = NextToken, Limit = Limit, AuthenticationType = AuthenticationType)
  output <- .appstream$describe_sessions_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_sessions <- appstream_describe_sessions

#' Retrieves a list that describes one or more specified stacks, if the
#' stack names are provided
#'
#' @description
#' Retrieves a list that describes one or more specified stacks, if the
#' stack names are provided. Otherwise, all stacks in the account are
#' described.
#'
#' @usage
#' appstream_describe_stacks(Names, NextToken)
#'
#' @param Names The names of the stacks to describe.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Stacks = list(
#'     list(
#'       Arn = "string",
#'       Name = "string",
#'       Description = "string",
#'       DisplayName = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StorageConnectors = list(
#'         list(
#'           ConnectorType = "HOMEFOLDERS"|"GOOGLE_DRIVE"|"ONE_DRIVE",
#'           ResourceIdentifier = "string",
#'           Domains = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       RedirectURL = "string",
#'       FeedbackURL = "string",
#'       StackErrors = list(
#'         list(
#'           ErrorCode = "STORAGE_CONNECTOR_ERROR"|"INTERNAL_SERVICE_ERROR",
#'           ErrorMessage = "string"
#'         )
#'       ),
#'       UserSettings = list(
#'         list(
#'           Action = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE"|"CLIPBOARD_COPY_TO_LOCAL_DEVICE"|"FILE_UPLOAD"|"FILE_DOWNLOAD"|"PRINTING_TO_LOCAL_DEVICE",
#'           Permission = "ENABLED"|"DISABLED"
#'         )
#'       ),
#'       ApplicationSettings = list(
#'         Enabled = TRUE|FALSE,
#'         SettingsGroup = "string",
#'         S3BucketName = "string"
#'       ),
#'       AccessEndpoints = list(
#'         list(
#'           EndpointType = "STREAMING",
#'           VpceId = "string"
#'         )
#'       ),
#'       EmbedHostDomains = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_stacks(
#'   Names = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_stacks
appstream_describe_stacks <- function(Names = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_stacks_input(Names = Names, NextToken = NextToken)
  output <- .appstream$describe_stacks_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_stacks <- appstream_describe_stacks

#' Retrieves a list that describes one or more usage report subscriptions
#'
#' @description
#' Retrieves a list that describes one or more usage report subscriptions.
#'
#' @usage
#' appstream_describe_usage_report_subscriptions(MaxResults, NextToken)
#'
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   UsageReportSubscriptions = list(
#'     list(
#'       S3BucketName = "string",
#'       Schedule = "DAILY",
#'       LastGeneratedReportDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       SubscriptionErrors = list(
#'         list(
#'           ErrorCode = "RESOURCE_NOT_FOUND"|"ACCESS_DENIED"|"INTERNAL_SERVICE_ERROR",
#'           ErrorMessage = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_usage_report_subscriptions(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_usage_report_subscriptions
appstream_describe_usage_report_subscriptions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUsageReportSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_usage_report_subscriptions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_usage_report_subscriptions_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_usage_report_subscriptions <- appstream_describe_usage_report_subscriptions

#' Retrieves a list that describes the UserStackAssociation objects
#'
#' @description
#' Retrieves a list that describes the UserStackAssociation objects. You
#' must specify either or both of the following:
#' 
#' -   The stack name
#' 
#' -   The user name (email address of the user associated with the stack)
#'     and the authentication type for the user
#'
#' @usage
#' appstream_describe_user_stack_associations(StackName, UserName,
#'   AuthenticationType, MaxResults, NextToken)
#'
#' @param StackName The name of the stack that is associated with the user.
#' @param UserName The email address of the user who is associated with the stack.
#' 
#' Users' email addresses are case-sensitive.
#' @param AuthenticationType The authentication type for the user who is associated with the stack.
#' You must specify USERPOOL.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   UserStackAssociations = list(
#'     list(
#'       StackName = "string",
#'       UserName = "string",
#'       AuthenticationType = "API"|"SAML"|"USERPOOL",
#'       SendEmailNotification = TRUE|FALSE
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_user_stack_associations(
#'   StackName = "string",
#'   UserName = "string",
#'   AuthenticationType = "API"|"SAML"|"USERPOOL",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_user_stack_associations
appstream_describe_user_stack_associations <- function(StackName = NULL, UserName = NULL, AuthenticationType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUserStackAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_user_stack_associations_input(StackName = StackName, UserName = UserName, AuthenticationType = AuthenticationType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_user_stack_associations_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_user_stack_associations <- appstream_describe_user_stack_associations

#' Retrieves a list that describes one or more specified users in the user
#' pool
#'
#' @description
#' Retrieves a list that describes one or more specified users in the user
#' pool.
#'
#' @usage
#' appstream_describe_users(AuthenticationType, MaxResults, NextToken)
#'
#' @param AuthenticationType &#91;required&#93; The authentication type for the users in the user pool to describe. You
#' must specify USERPOOL.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Users = list(
#'     list(
#'       Arn = "string",
#'       UserName = "string",
#'       Enabled = TRUE|FALSE,
#'       Status = "string",
#'       FirstName = "string",
#'       LastName = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       AuthenticationType = "API"|"SAML"|"USERPOOL"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_users(
#'   AuthenticationType = "API"|"SAML"|"USERPOOL",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_describe_users
appstream_describe_users <- function(AuthenticationType, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$describe_users_input(AuthenticationType = AuthenticationType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_users_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_users <- appstream_describe_users

#' Disables the specified user in the user pool
#'
#' @description
#' Disables the specified user in the user pool. Users can't sign in to
#' AppStream 2.0 until they are re-enabled. This action does not delete the
#' user.
#'
#' @usage
#' appstream_disable_user(UserName, AuthenticationType)
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disable_user(
#'   UserName = "string",
#'   AuthenticationType = "API"|"SAML"|"USERPOOL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_disable_user
appstream_disable_user <- function(UserName, AuthenticationType) {
  op <- new_operation(
    name = "DisableUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$disable_user_input(UserName = UserName, AuthenticationType = AuthenticationType)
  output <- .appstream$disable_user_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$disable_user <- appstream_disable_user

#' Disassociates the specified fleet from the specified stack
#'
#' @description
#' Disassociates the specified fleet from the specified stack.
#'
#' @usage
#' appstream_disassociate_fleet(FleetName, StackName)
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param StackName &#91;required&#93; The name of the stack.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_fleet(
#'   FleetName = "string",
#'   StackName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_disassociate_fleet
appstream_disassociate_fleet <- function(FleetName, StackName) {
  op <- new_operation(
    name = "DisassociateFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$disassociate_fleet_input(FleetName = FleetName, StackName = StackName)
  output <- .appstream$disassociate_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$disassociate_fleet <- appstream_disassociate_fleet

#' Enables a user in the user pool
#'
#' @description
#' Enables a user in the user pool. After being enabled, users can sign in
#' to AppStream 2.0 and open applications from the stacks to which they are
#' assigned.
#'
#' @usage
#' appstream_enable_user(UserName, AuthenticationType)
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive. During login, if they specify
#' an email address that doesn't use the same capitalization as the email
#' address specified when their user pool account was created, a "user does
#' not exist" error message displays.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$enable_user(
#'   UserName = "string",
#'   AuthenticationType = "API"|"SAML"|"USERPOOL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_enable_user
appstream_enable_user <- function(UserName, AuthenticationType) {
  op <- new_operation(
    name = "EnableUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$enable_user_input(UserName = UserName, AuthenticationType = AuthenticationType)
  output <- .appstream$enable_user_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$enable_user <- appstream_enable_user

#' Immediately stops the specified streaming session
#'
#' @description
#' Immediately stops the specified streaming session.
#'
#' @usage
#' appstream_expire_session(SessionId)
#'
#' @param SessionId &#91;required&#93; The identifier of the streaming session.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$expire_session(
#'   SessionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_expire_session
appstream_expire_session <- function(SessionId) {
  op <- new_operation(
    name = "ExpireSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$expire_session_input(SessionId = SessionId)
  output <- .appstream$expire_session_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$expire_session <- appstream_expire_session

#' Retrieves the name of the fleet that is associated with the specified
#' stack
#'
#' @description
#' Retrieves the name of the fleet that is associated with the specified
#' stack.
#'
#' @usage
#' appstream_list_associated_fleets(StackName, NextToken)
#'
#' @param StackName &#91;required&#93; The name of the stack.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Names = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_associated_fleets(
#'   StackName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_list_associated_fleets
appstream_list_associated_fleets <- function(StackName, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociatedFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$list_associated_fleets_input(StackName = StackName, NextToken = NextToken)
  output <- .appstream$list_associated_fleets_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$list_associated_fleets <- appstream_list_associated_fleets

#' Retrieves the name of the stack with which the specified fleet is
#' associated
#'
#' @description
#' Retrieves the name of the stack with which the specified fleet is
#' associated.
#'
#' @usage
#' appstream_list_associated_stacks(FleetName, NextToken)
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Names = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_associated_stacks(
#'   FleetName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_list_associated_stacks
appstream_list_associated_stacks <- function(FleetName, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociatedStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$list_associated_stacks_input(FleetName = FleetName, NextToken = NextToken)
  output <- .appstream$list_associated_stacks_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$list_associated_stacks <- appstream_list_associated_stacks

#' Retrieves a list of all tags for the specified AppStream 2
#'
#' @description
#' Retrieves a list of all tags for the specified AppStream 2.0 resource.
#' You can tag AppStream 2.0 image builders, images, fleets, and stacks.
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#'
#' @usage
#' appstream_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_list_tags_for_resource
appstream_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .appstream$list_tags_for_resource_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$list_tags_for_resource <- appstream_list_tags_for_resource

#' Starts the specified fleet
#'
#' @description
#' Starts the specified fleet.
#'
#' @usage
#' appstream_start_fleet(Name)
#'
#' @param Name &#91;required&#93; The name of the fleet.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$start_fleet(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_start_fleet
appstream_start_fleet <- function(Name) {
  op <- new_operation(
    name = "StartFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$start_fleet_input(Name = Name)
  output <- .appstream$start_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$start_fleet <- appstream_start_fleet

#' Starts the specified image builder
#'
#' @description
#' Starts the specified image builder.
#'
#' @usage
#' appstream_start_image_builder(Name, AppstreamAgentVersion)
#'
#' @param Name &#91;required&#93; The name of the image builder.
#' @param AppstreamAgentVersion The version of the AppStream 2.0 agent to use for this image builder. To
#' use the latest version of the AppStream 2.0 agent, specify \[LATEST\].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageBuilder = list(
#'     Name = "string",
#'     Arn = "string",
#'     ImageArn = "string",
#'     Description = "string",
#'     DisplayName = "string",
#'     VpcConfig = list(
#'       SubnetIds = list(
#'         "string"
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     InstanceType = "string",
#'     Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
#'     IamRoleArn = "string",
#'     State = "PENDING"|"UPDATING_AGENT"|"RUNNING"|"STOPPING"|"STOPPED"|"REBOOTING"|"SNAPSHOTTING"|"DELETING"|"FAILED",
#'     StateChangeReason = list(
#'       Code = "INTERNAL_ERROR"|"IMAGE_UNAVAILABLE",
#'       Message = "string"
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EnableDefaultInternetAccess = TRUE|FALSE,
#'     DomainJoinInfo = list(
#'       DirectoryName = "string",
#'       OrganizationalUnitDistinguishedName = "string"
#'     ),
#'     NetworkAccessConfiguration = list(
#'       EniPrivateIpAddress = "string",
#'       EniId = "string"
#'     ),
#'     ImageBuilderErrors = list(
#'       list(
#'         ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string",
#'         ErrorTimestamp = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     AppstreamAgentVersion = "string",
#'     AccessEndpoints = list(
#'       list(
#'         EndpointType = "STREAMING",
#'         VpceId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_image_builder(
#'   Name = "string",
#'   AppstreamAgentVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_start_image_builder
appstream_start_image_builder <- function(Name, AppstreamAgentVersion = NULL) {
  op <- new_operation(
    name = "StartImageBuilder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$start_image_builder_input(Name = Name, AppstreamAgentVersion = AppstreamAgentVersion)
  output <- .appstream$start_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$start_image_builder <- appstream_start_image_builder

#' Stops the specified fleet
#'
#' @description
#' Stops the specified fleet.
#'
#' @usage
#' appstream_stop_fleet(Name)
#'
#' @param Name &#91;required&#93; The name of the fleet.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$stop_fleet(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_stop_fleet
appstream_stop_fleet <- function(Name) {
  op <- new_operation(
    name = "StopFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$stop_fleet_input(Name = Name)
  output <- .appstream$stop_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$stop_fleet <- appstream_stop_fleet

#' Stops the specified image builder
#'
#' @description
#' Stops the specified image builder.
#'
#' @usage
#' appstream_stop_image_builder(Name)
#'
#' @param Name &#91;required&#93; The name of the image builder.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImageBuilder = list(
#'     Name = "string",
#'     Arn = "string",
#'     ImageArn = "string",
#'     Description = "string",
#'     DisplayName = "string",
#'     VpcConfig = list(
#'       SubnetIds = list(
#'         "string"
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     InstanceType = "string",
#'     Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
#'     IamRoleArn = "string",
#'     State = "PENDING"|"UPDATING_AGENT"|"RUNNING"|"STOPPING"|"STOPPED"|"REBOOTING"|"SNAPSHOTTING"|"DELETING"|"FAILED",
#'     StateChangeReason = list(
#'       Code = "INTERNAL_ERROR"|"IMAGE_UNAVAILABLE",
#'       Message = "string"
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EnableDefaultInternetAccess = TRUE|FALSE,
#'     DomainJoinInfo = list(
#'       DirectoryName = "string",
#'       OrganizationalUnitDistinguishedName = "string"
#'     ),
#'     NetworkAccessConfiguration = list(
#'       EniPrivateIpAddress = "string",
#'       EniId = "string"
#'     ),
#'     ImageBuilderErrors = list(
#'       list(
#'         ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string",
#'         ErrorTimestamp = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     AppstreamAgentVersion = "string",
#'     AccessEndpoints = list(
#'       list(
#'         EndpointType = "STREAMING",
#'         VpceId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_image_builder(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_stop_image_builder
appstream_stop_image_builder <- function(Name) {
  op <- new_operation(
    name = "StopImageBuilder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$stop_image_builder_input(Name = Name)
  output <- .appstream$stop_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$stop_image_builder <- appstream_stop_image_builder

#' Adds or overwrites one or more tags for the specified AppStream 2
#'
#' @description
#' Adds or overwrites one or more tags for the specified AppStream 2.0
#' resource. You can tag AppStream 2.0 image builders, images, fleets, and
#' stacks.
#' 
#' Each tag consists of a key and an optional value. If a resource already
#' has a tag with the same key, this operation updates its value.
#' 
#' To list the current tags for your resources, use
#' [`list_tags_for_resource`][appstream_list_tags_for_resource]. To
#' disassociate tags from your resources, use
#' [`untag_resource`][appstream_untag_resource].
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#'
#' @usage
#' appstream_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; The tags to associate. A tag is a key-value pair, and the value is
#' optional. For example, Environment=Test. If you do not specify a value,
#' Environment=.
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_tag_resource
appstream_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .appstream$tag_resource_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$tag_resource <- appstream_tag_resource

#' Disassociates one or more specified tags from the specified AppStream 2
#'
#' @description
#' Disassociates one or more specified tags from the specified AppStream
#' 2.0 resource.
#' 
#' To list the current tags for your resources, use
#' [`list_tags_for_resource`][appstream_list_tags_for_resource].
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#'
#' @usage
#' appstream_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; The tag keys for the tags to disassociate.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_untag_resource
appstream_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .appstream$untag_resource_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$untag_resource <- appstream_untag_resource

#' Updates the specified Directory Config object in AppStream 2
#'
#' @description
#' Updates the specified Directory Config object in AppStream 2.0. This
#' object includes the configuration information required to join fleets
#' and image builders to Microsoft Active Directory domains.
#'
#' @usage
#' appstream_update_directory_config(DirectoryName,
#'   OrganizationalUnitDistinguishedNames, ServiceAccountCredentials)
#'
#' @param DirectoryName &#91;required&#93; The name of the Directory Config object.
#' @param OrganizationalUnitDistinguishedNames The distinguished names of the organizational units for computer
#' accounts.
#' @param ServiceAccountCredentials The credentials for the service account used by the fleet or image
#' builder to connect to the directory.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DirectoryConfig = list(
#'     DirectoryName = "string",
#'     OrganizationalUnitDistinguishedNames = list(
#'       "string"
#'     ),
#'     ServiceAccountCredentials = list(
#'       AccountName = "string",
#'       AccountPassword = "string"
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_directory_config(
#'   DirectoryName = "string",
#'   OrganizationalUnitDistinguishedNames = list(
#'     "string"
#'   ),
#'   ServiceAccountCredentials = list(
#'     AccountName = "string",
#'     AccountPassword = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_update_directory_config
appstream_update_directory_config <- function(DirectoryName, OrganizationalUnitDistinguishedNames = NULL, ServiceAccountCredentials = NULL) {
  op <- new_operation(
    name = "UpdateDirectoryConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$update_directory_config_input(DirectoryName = DirectoryName, OrganizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNames, ServiceAccountCredentials = ServiceAccountCredentials)
  output <- .appstream$update_directory_config_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_directory_config <- appstream_update_directory_config

#' Updates the specified fleet
#'
#' @description
#' Updates the specified fleet.
#' 
#' If the fleet is in the `STOPPED` state, you can update any attribute
#' except the fleet name. If the fleet is in the `RUNNING` state, you can
#' update the `DisplayName`, `ComputeCapacity`, `ImageARN`, `ImageName`,
#' `IdleDisconnectTimeoutInSeconds`, and `DisconnectTimeoutInSeconds`
#' attributes. If the fleet is in the `STARTING` or `STOPPING` state, you
#' can't update it.
#'
#' @usage
#' appstream_update_fleet(ImageName, ImageArn, Name, InstanceType,
#'   ComputeCapacity, VpcConfig, MaxUserDurationInSeconds,
#'   DisconnectTimeoutInSeconds, DeleteVpcConfig, Description, DisplayName,
#'   EnableDefaultInternetAccess, DomainJoinInfo,
#'   IdleDisconnectTimeoutInSeconds, AttributesToDelete, IamRoleArn,
#'   StreamView)
#'
#' @param ImageName The name of the image used to create the fleet.
#' @param ImageArn The ARN of the public, private, or shared image to use.
#' @param Name A unique name for the fleet.
#' @param InstanceType The instance type to use when launching fleet instances. The following
#' instance types are available:
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.compute.large
#' 
#' -   stream.compute.xlarge
#' 
#' -   stream.compute.2xlarge
#' 
#' -   stream.compute.4xlarge
#' 
#' -   stream.compute.8xlarge
#' 
#' -   stream.memory.large
#' 
#' -   stream.memory.xlarge
#' 
#' -   stream.memory.2xlarge
#' 
#' -   stream.memory.4xlarge
#' 
#' -   stream.memory.8xlarge
#' 
#' -   stream.memory.z1d.large
#' 
#' -   stream.memory.z1d.xlarge
#' 
#' -   stream.memory.z1d.2xlarge
#' 
#' -   stream.memory.z1d.3xlarge
#' 
#' -   stream.memory.z1d.6xlarge
#' 
#' -   stream.memory.z1d.12xlarge
#' 
#' -   stream.graphics-design.large
#' 
#' -   stream.graphics-design.xlarge
#' 
#' -   stream.graphics-design.2xlarge
#' 
#' -   stream.graphics-design.4xlarge
#' 
#' -   stream.graphics-desktop.2xlarge
#' 
#' -   stream.graphics.g4dn.xlarge
#' 
#' -   stream.graphics.g4dn.2xlarge
#' 
#' -   stream.graphics.g4dn.4xlarge
#' 
#' -   stream.graphics.g4dn.8xlarge
#' 
#' -   stream.graphics.g4dn.12xlarge
#' 
#' -   stream.graphics.g4dn.16xlarge
#' 
#' -   stream.graphics-pro.4xlarge
#' 
#' -   stream.graphics-pro.8xlarge
#' 
#' -   stream.graphics-pro.16xlarge
#' @param ComputeCapacity The desired capacity for the fleet.
#' @param VpcConfig The VPC configuration for the fleet.
#' @param MaxUserDurationInSeconds The maximum amount of time that a streaming session can remain active,
#' in seconds. If users are still connected to a streaming instance five
#' minutes before this limit is reached, they are prompted to save any open
#' documents before being disconnected. After this time elapses, the
#' instance is terminated and replaced by a new instance.
#' 
#' Specify a value between 600 and 360000.
#' @param DisconnectTimeoutInSeconds The amount of time that a streaming session remains active after users
#' disconnect. If users try to reconnect to the streaming session after a
#' disconnection or network interruption within this time interval, they
#' are connected to their previous session. Otherwise, they are connected
#' to a new session with a new streaming instance.
#' 
#' Specify a value between 60 and 360000.
#' @param DeleteVpcConfig Deletes the VPC association for the specified fleet.
#' @param Description The description to display.
#' @param DisplayName The fleet name to display.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the fleet.
#' @param DomainJoinInfo The name of the directory and organizational unit (OU) to use to join
#' the fleet to a Microsoft Active Directory domain.
#' @param IdleDisconnectTimeoutInSeconds The amount of time that users can be idle (inactive) before they are
#' disconnected from their streaming session and the
#' `DisconnectTimeoutInSeconds` time interval begins. Users are notified
#' before they are disconnected due to inactivity. If users try to
#' reconnect to the streaming session before the time interval specified in
#' `DisconnectTimeoutInSeconds` elapses, they are connected to their
#' previous session. Users are considered idle when they stop providing
#' keyboard or mouse input during their streaming session. File uploads and
#' downloads, audio in, audio out, and pixels changing do not qualify as
#' user activity. If users continue to be idle after the time interval in
#' `IdleDisconnectTimeoutInSeconds` elapses, they are disconnected.
#' 
#' To prevent users from being disconnected due to inactivity, specify a
#' value of 0. Otherwise, specify a value between 60 and 3600. The default
#' value is 0.
#' 
#' If you enable this feature, we recommend that you specify a value that
#' corresponds exactly to a whole number of minutes (for example, 60, 120,
#' and 180). If you don't do this, the value is rounded to the nearest
#' minute. For example, if you specify a value of 70, users are
#' disconnected after 1 minute of inactivity. If you specify a value that
#' is at the midpoint between two different minutes, the value is rounded
#' up. For example, if you specify a value of 90, users are disconnected
#' after 2 minutes of inactivity.
#' @param AttributesToDelete The fleet attributes to delete.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
#' assume a role, a fleet instance calls the AWS Security Token Service
#' (STS) `AssumeRole` API operation and passes the ARN of the role to use.
#' The operation creates a new session with temporary credentials.
#' AppStream 2.0 retrieves the temporary credentials and creates the
#' **appstream_machine_role** credential profile on the instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param StreamView The AppStream 2.0 view that is displayed to your users when they stream
#' from the fleet. When `APP` is specified, only the windows of
#' applications opened by users display. When `DESKTOP` is specified, the
#' standard desktop that is provided by the operating system displays.
#' 
#' The default value is `APP`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Fleet = list(
#'     Arn = "string",
#'     Name = "string",
#'     DisplayName = "string",
#'     Description = "string",
#'     ImageName = "string",
#'     ImageArn = "string",
#'     InstanceType = "string",
#'     FleetType = "ALWAYS_ON"|"ON_DEMAND",
#'     ComputeCapacityStatus = list(
#'       Desired = 123,
#'       Running = 123,
#'       InUse = 123,
#'       Available = 123
#'     ),
#'     MaxUserDurationInSeconds = 123,
#'     DisconnectTimeoutInSeconds = 123,
#'     State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED",
#'     VpcConfig = list(
#'       SubnetIds = list(
#'         "string"
#'       ),
#'       SecurityGroupIds = list(
#'         "string"
#'       )
#'     ),
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     FleetErrors = list(
#'       list(
#'         ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string"
#'       )
#'     ),
#'     EnableDefaultInternetAccess = TRUE|FALSE,
#'     DomainJoinInfo = list(
#'       DirectoryName = "string",
#'       OrganizationalUnitDistinguishedName = "string"
#'     ),
#'     IdleDisconnectTimeoutInSeconds = 123,
#'     IamRoleArn = "string",
#'     StreamView = "APP"|"DESKTOP"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_fleet(
#'   ImageName = "string",
#'   ImageArn = "string",
#'   Name = "string",
#'   InstanceType = "string",
#'   ComputeCapacity = list(
#'     DesiredInstances = 123
#'   ),
#'   VpcConfig = list(
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   MaxUserDurationInSeconds = 123,
#'   DisconnectTimeoutInSeconds = 123,
#'   DeleteVpcConfig = TRUE|FALSE,
#'   Description = "string",
#'   DisplayName = "string",
#'   EnableDefaultInternetAccess = TRUE|FALSE,
#'   DomainJoinInfo = list(
#'     DirectoryName = "string",
#'     OrganizationalUnitDistinguishedName = "string"
#'   ),
#'   IdleDisconnectTimeoutInSeconds = 123,
#'   AttributesToDelete = list(
#'     "VPC_CONFIGURATION"|"VPC_CONFIGURATION_SECURITY_GROUP_IDS"|"DOMAIN_JOIN_INFO"|"IAM_ROLE_ARN"
#'   ),
#'   IamRoleArn = "string",
#'   StreamView = "APP"|"DESKTOP"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_update_fleet
appstream_update_fleet <- function(ImageName = NULL, ImageArn = NULL, Name = NULL, InstanceType = NULL, ComputeCapacity = NULL, VpcConfig = NULL, MaxUserDurationInSeconds = NULL, DisconnectTimeoutInSeconds = NULL, DeleteVpcConfig = NULL, Description = NULL, DisplayName = NULL, EnableDefaultInternetAccess = NULL, DomainJoinInfo = NULL, IdleDisconnectTimeoutInSeconds = NULL, AttributesToDelete = NULL, IamRoleArn = NULL, StreamView = NULL) {
  op <- new_operation(
    name = "UpdateFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$update_fleet_input(ImageName = ImageName, ImageArn = ImageArn, Name = Name, InstanceType = InstanceType, ComputeCapacity = ComputeCapacity, VpcConfig = VpcConfig, MaxUserDurationInSeconds = MaxUserDurationInSeconds, DisconnectTimeoutInSeconds = DisconnectTimeoutInSeconds, DeleteVpcConfig = DeleteVpcConfig, Description = Description, DisplayName = DisplayName, EnableDefaultInternetAccess = EnableDefaultInternetAccess, DomainJoinInfo = DomainJoinInfo, IdleDisconnectTimeoutInSeconds = IdleDisconnectTimeoutInSeconds, AttributesToDelete = AttributesToDelete, IamRoleArn = IamRoleArn, StreamView = StreamView)
  output <- .appstream$update_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_fleet <- appstream_update_fleet

#' Adds or updates permissions for the specified private image
#'
#' @description
#' Adds or updates permissions for the specified private image.
#'
#' @usage
#' appstream_update_image_permissions(Name, SharedAccountId,
#'   ImagePermissions)
#'
#' @param Name &#91;required&#93; The name of the private image.
#' @param SharedAccountId &#91;required&#93; The 12-digit identifier of the AWS account for which you want add or
#' update image permissions.
#' @param ImagePermissions &#91;required&#93; The permissions for the image.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_image_permissions(
#'   Name = "string",
#'   SharedAccountId = "string",
#'   ImagePermissions = list(
#'     allowFleet = TRUE|FALSE,
#'     allowImageBuilder = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_update_image_permissions
appstream_update_image_permissions <- function(Name, SharedAccountId, ImagePermissions) {
  op <- new_operation(
    name = "UpdateImagePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$update_image_permissions_input(Name = Name, SharedAccountId = SharedAccountId, ImagePermissions = ImagePermissions)
  output <- .appstream$update_image_permissions_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_image_permissions <- appstream_update_image_permissions

#' Updates the specified fields for the specified stack
#'
#' @description
#' Updates the specified fields for the specified stack.
#'
#' @usage
#' appstream_update_stack(DisplayName, Description, Name,
#'   StorageConnectors, DeleteStorageConnectors, RedirectURL, FeedbackURL,
#'   AttributesToDelete, UserSettings, ApplicationSettings, AccessEndpoints,
#'   EmbedHostDomains)
#'
#' @param DisplayName The stack name to display.
#' @param Description The description to display.
#' @param Name &#91;required&#93; The name of the stack.
#' @param StorageConnectors The storage connectors to enable.
#' @param DeleteStorageConnectors Deletes the storage connectors currently enabled for the stack.
#' @param RedirectURL The URL that users are redirected to after their streaming session ends.
#' @param FeedbackURL The URL that users are redirected to after they choose the Send Feedback
#' link. If no URL is specified, no Send Feedback link is displayed.
#' @param AttributesToDelete The stack attributes to delete.
#' @param UserSettings The actions that are enabled or disabled for users during their
#' streaming sessions. By default, these actions are enabled.
#' @param ApplicationSettings The persistent application settings for users of a stack. When these
#' settings are enabled, changes that users make to applications and
#' Windows settings are automatically saved after each session and applied
#' to the next session.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects. Users
#' of the stack can connect to AppStream 2.0 only through the specified
#' endpoints.
#' @param EmbedHostDomains The domains where AppStream 2.0 streaming sessions can be embedded in an
#' iframe. You must approve the domains that you want to host embedded
#' AppStream 2.0 streaming sessions.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Stack = list(
#'     Arn = "string",
#'     Name = "string",
#'     Description = "string",
#'     DisplayName = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StorageConnectors = list(
#'       list(
#'         ConnectorType = "HOMEFOLDERS"|"GOOGLE_DRIVE"|"ONE_DRIVE",
#'         ResourceIdentifier = "string",
#'         Domains = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     RedirectURL = "string",
#'     FeedbackURL = "string",
#'     StackErrors = list(
#'       list(
#'         ErrorCode = "STORAGE_CONNECTOR_ERROR"|"INTERNAL_SERVICE_ERROR",
#'         ErrorMessage = "string"
#'       )
#'     ),
#'     UserSettings = list(
#'       list(
#'         Action = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE"|"CLIPBOARD_COPY_TO_LOCAL_DEVICE"|"FILE_UPLOAD"|"FILE_DOWNLOAD"|"PRINTING_TO_LOCAL_DEVICE",
#'         Permission = "ENABLED"|"DISABLED"
#'       )
#'     ),
#'     ApplicationSettings = list(
#'       Enabled = TRUE|FALSE,
#'       SettingsGroup = "string",
#'       S3BucketName = "string"
#'     ),
#'     AccessEndpoints = list(
#'       list(
#'         EndpointType = "STREAMING",
#'         VpceId = "string"
#'       )
#'     ),
#'     EmbedHostDomains = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_stack(
#'   DisplayName = "string",
#'   Description = "string",
#'   Name = "string",
#'   StorageConnectors = list(
#'     list(
#'       ConnectorType = "HOMEFOLDERS"|"GOOGLE_DRIVE"|"ONE_DRIVE",
#'       ResourceIdentifier = "string",
#'       Domains = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DeleteStorageConnectors = TRUE|FALSE,
#'   RedirectURL = "string",
#'   FeedbackURL = "string",
#'   AttributesToDelete = list(
#'     "STORAGE_CONNECTORS"|"STORAGE_CONNECTOR_HOMEFOLDERS"|"STORAGE_CONNECTOR_GOOGLE_DRIVE"|"STORAGE_CONNECTOR_ONE_DRIVE"|"REDIRECT_URL"|"FEEDBACK_URL"|"THEME_NAME"|"USER_SETTINGS"|"EMBED_HOST_DOMAINS"|"IAM_ROLE_ARN"|"ACCESS_ENDPOINTS"
#'   ),
#'   UserSettings = list(
#'     list(
#'       Action = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE"|"CLIPBOARD_COPY_TO_LOCAL_DEVICE"|"FILE_UPLOAD"|"FILE_DOWNLOAD"|"PRINTING_TO_LOCAL_DEVICE",
#'       Permission = "ENABLED"|"DISABLED"
#'     )
#'   ),
#'   ApplicationSettings = list(
#'     Enabled = TRUE|FALSE,
#'     SettingsGroup = "string"
#'   ),
#'   AccessEndpoints = list(
#'     list(
#'       EndpointType = "STREAMING",
#'       VpceId = "string"
#'     )
#'   ),
#'   EmbedHostDomains = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname appstream_update_stack
appstream_update_stack <- function(DisplayName = NULL, Description = NULL, Name, StorageConnectors = NULL, DeleteStorageConnectors = NULL, RedirectURL = NULL, FeedbackURL = NULL, AttributesToDelete = NULL, UserSettings = NULL, ApplicationSettings = NULL, AccessEndpoints = NULL, EmbedHostDomains = NULL) {
  op <- new_operation(
    name = "UpdateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .appstream$update_stack_input(DisplayName = DisplayName, Description = Description, Name = Name, StorageConnectors = StorageConnectors, DeleteStorageConnectors = DeleteStorageConnectors, RedirectURL = RedirectURL, FeedbackURL = FeedbackURL, AttributesToDelete = AttributesToDelete, UserSettings = UserSettings, ApplicationSettings = ApplicationSettings, AccessEndpoints = AccessEndpoints, EmbedHostDomains = EmbedHostDomains)
  output <- .appstream$update_stack_output()
  config <- get_config()
  svc <- .appstream$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_stack <- appstream_update_stack
