% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_get_document_version}
\alias{workdocs_get_document_version}
\title{Retrieves version metadata for the specified document}
\usage{
workdocs_get_document_version(AuthenticationToken, DocumentId,
  VersionId, Fields, IncludeCustomMetadata)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{VersionId}{[required] The version ID of the document.}

\item{Fields}{A comma-separated list of values. Specify "SOURCE" to include a URL for
the source document.}

\item{IncludeCustomMetadata}{Set this to TRUE to include custom metadata in the response.}
}
\value{
A list with the following syntax:\preformatted{list(
  Metadata = list(
    Id = "string",
    Name = "string",
    ContentType = "string",
    Size = 123,
    Signature = "string",
    Status = "INITIALIZED"|"ACTIVE",
    CreatedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ModifiedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ContentCreatedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ContentModifiedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    CreatorId = "string",
    Thumbnail = list(
      "string"
    ),
    Source = list(
      "string"
    )
  ),
  CustomMetadata = list(
    "string"
  )
)
}
}
\description{
Retrieves version metadata for the specified document.
}
\section{Request syntax}{
\preformatted{svc$get_document_version(
  AuthenticationToken = "string",
  DocumentId = "string",
  VersionId = "string",
  Fields = "string",
  IncludeCustomMetadata = TRUE|FALSE
)
}
}

\keyword{internal}
