% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_create_user}
\alias{workdocs_create_user}
\title{Creates a user in a Simple AD or Microsoft AD directory}
\usage{
workdocs_create_user(
  OrganizationId = NULL,
  Username,
  EmailAddress = NULL,
  GivenName,
  Surname,
  Password,
  TimeZoneId = NULL,
  StorageRule = NULL,
  AuthenticationToken = NULL
)
}
\arguments{
\item{OrganizationId}{The ID of the organization.}

\item{Username}{[required] The login name of the user.}

\item{EmailAddress}{The email address of the user.}

\item{GivenName}{[required] The given name of the user.}

\item{Surname}{[required] The surname of the user.}

\item{Password}{[required] The password of the user.}

\item{TimeZoneId}{The time zone ID of the user.}

\item{StorageRule}{The amount of storage for the user.}

\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using Amazon Web
Services administrator credentials to access the API.}
}
\description{
Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New users can access Amazon WorkDocs.

See \url{https://www.paws-r-sdk.com/docs/workdocs_create_user/} for full documentation.
}
\keyword{internal}
