% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehendmedical_operations.R
\name{comprehendmedical_detect_entities_v2}
\alias{comprehendmedical_detect_entities_v2}
\title{Inspects the clinical text for a variety of medical entities and returns
specific information about them such as entity category, location, and
confidence score on that information}
\usage{
comprehendmedical_detect_entities_v2(Text)
}
\arguments{
\item{Text}{[required] A UTF-8 string containing the clinical content being examined for
entities. Each string must contain fewer than 20,000 bytes of
characters.}
}
\description{
Inspects the clinical text for a variety of medical entities and returns
specific information about them such as entity category, location, and
confidence score on that information. Amazon Comprehend Medical only
detects medical entities in English language texts.

The \code{DetectEntitiesV2} operation replaces the DetectEntities operation.
This new action uses a different model for determining the entities in
your medical text and changes the way that some entities are returned in
the output. You should use the \code{DetectEntitiesV2} operation in all new
applications.

The \code{DetectEntitiesV2} operation returns the \code{Acuity} and \code{Direction}
entities as attributes instead of types.
}
\section{Request syntax}{
\preformatted{svc$detect_entities_v2(
  Text = "string"
)
}
}

\keyword{internal}
