% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_create_parallel_data}
\alias{translate_create_parallel_data}
\title{Creates a parallel data resource in Amazon Translate by importing an
input file from Amazon S3}
\usage{
translate_create_parallel_data(Name, Description, ParallelDataConfig,
  EncryptionKey, ClientToken)
}
\arguments{
\item{Name}{[required] A custom name for the parallel data resource in Amazon Translate. You
must assign a name that is unique in the account and region.}

\item{Description}{A custom description for the parallel data resource in Amazon Translate.}

\item{ParallelDataConfig}{[required] Specifies the format and S3 location of the parallel data input file.}

\item{EncryptionKey}{}

\item{ClientToken}{[required] A unique identifier for the request. This token is automatically
generated when you use Amazon Translate through an AWS SDK.}
}
\description{
Creates a parallel data resource in Amazon Translate by importing an
input file from Amazon S3. Parallel data files contain examples of
source phrases and their translations from your translation memory. By
adding parallel data, you can influence the style, tone, and word choice
in your translation output.
}
\section{Request syntax}{
\preformatted{svc$create_parallel_data(
  Name = "string",
  Description = "string",
  ParallelDataConfig = list(
    S3Uri = "string",
    Format = "TSV"|"CSV"|"TMX"
  ),
  EncryptionKey = list(
    Type = "KMS",
    Id = "string"
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
