% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_edge_packaging_jobs}
\alias{sagemaker_list_edge_packaging_jobs}
\title{Returns a list of edge packaging jobs}
\usage{
sagemaker_list_edge_packaging_jobs(NextToken, MaxResults,
  CreationTimeAfter, CreationTimeBefore, LastModifiedTimeAfter,
  LastModifiedTimeBefore, NameContains, ModelNameContains, StatusEquals,
  SortBy, SortOrder)
}
\arguments{
\item{NextToken}{The response from the last list when returning a list large enough to
need tokening.}

\item{MaxResults}{Maximum number of results to select.}

\item{CreationTimeAfter}{Select jobs where the job was created after specified time.}

\item{CreationTimeBefore}{Select jobs where the job was created before specified time.}

\item{LastModifiedTimeAfter}{Select jobs where the job was updated after specified time.}

\item{LastModifiedTimeBefore}{Select jobs where the job was updated before specified time.}

\item{NameContains}{Filter for jobs containing this name in their packaging job name.}

\item{ModelNameContains}{Filter for jobs where the model name contains this string.}

\item{StatusEquals}{The job status to filter for.}

\item{SortBy}{Use to specify what column to sort by.}

\item{SortOrder}{What direction to sort by.}
}
\value{
A list with the following syntax:\preformatted{list(
  EdgePackagingJobSummaries = list(
    list(
      EdgePackagingJobArn = "string",
      EdgePackagingJobName = "string",
      EdgePackagingJobStatus = "STARTING"|"INPROGRESS"|"COMPLETED"|"FAILED"|"STOPPING"|"STOPPED",
      CompilationJobName = "string",
      ModelName = "string",
      ModelVersion = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of edge packaging jobs.
}
\section{Request syntax}{
\preformatted{svc$list_edge_packaging_jobs(
  NextToken = "string",
  MaxResults = 123,
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  NameContains = "string",
  ModelNameContains = "string",
  StatusEquals = "STARTING"|"INPROGRESS"|"COMPLETED"|"FAILED"|"STOPPING"|"STOPPED",
  SortBy = "NAME"|"MODEL_NAME"|"CREATION_TIME"|"LAST_MODIFIED_TIME"|"STATUS",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
