# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Personalize
#'
#' @description
#' Amazon Personalize is a machine learning service that makes it easy to
#' add individualized recommendations to customers.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- personalize(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- personalize()
#' svc$create_batch_inference_job(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=personalize_create_batch_inference_job]{create_batch_inference_job} \tab Creates a batch inference job\cr
#'  \link[=personalize_create_campaign]{create_campaign} \tab Creates a campaign by deploying a solution version\cr
#'  \link[=personalize_create_dataset]{create_dataset} \tab Creates an empty dataset and adds it to the specified dataset group\cr
#'  \link[=personalize_create_dataset_group]{create_dataset_group} \tab Creates an empty dataset group\cr
#'  \link[=personalize_create_dataset_import_job]{create_dataset_import_job} \tab Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset\cr
#'  \link[=personalize_create_event_tracker]{create_event_tracker} \tab Creates an event tracker that you use when sending event data to the specified dataset group using the PutEvents API\cr
#'  \link[=personalize_create_filter]{create_filter} \tab Creates a recommendation filter\cr
#'  \link[=personalize_create_schema]{create_schema} \tab Creates an Amazon Personalize schema from the specified schema string\cr
#'  \link[=personalize_create_solution]{create_solution} \tab Creates the configuration for training a model\cr
#'  \link[=personalize_create_solution_version]{create_solution_version} \tab Trains or retrains an active solution\cr
#'  \link[=personalize_delete_campaign]{delete_campaign} \tab Removes a campaign by deleting the solution deployment\cr
#'  \link[=personalize_delete_dataset]{delete_dataset} \tab Deletes a dataset\cr
#'  \link[=personalize_delete_dataset_group]{delete_dataset_group} \tab Deletes a dataset group\cr
#'  \link[=personalize_delete_event_tracker]{delete_event_tracker} \tab Deletes the event tracker\cr
#'  \link[=personalize_delete_filter]{delete_filter} \tab Deletes a filter\cr
#'  \link[=personalize_delete_schema]{delete_schema} \tab Deletes a schema\cr
#'  \link[=personalize_delete_solution]{delete_solution} \tab Deletes all versions of a solution and the Solution object itself\cr
#'  \link[=personalize_describe_algorithm]{describe_algorithm} \tab Describes the given algorithm\cr
#'  \link[=personalize_describe_batch_inference_job]{describe_batch_inference_job} \tab Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations\cr
#'  \link[=personalize_describe_campaign]{describe_campaign} \tab Describes the given campaign, including its status\cr
#'  \link[=personalize_describe_dataset]{describe_dataset} \tab Describes the given dataset\cr
#'  \link[=personalize_describe_dataset_group]{describe_dataset_group} \tab Describes the given dataset group\cr
#'  \link[=personalize_describe_dataset_import_job]{describe_dataset_import_job} \tab Describes the dataset import job created by CreateDatasetImportJob, including the import job status\cr
#'  \link[=personalize_describe_event_tracker]{describe_event_tracker} \tab Describes an event tracker\cr
#'  \link[=personalize_describe_feature_transformation]{describe_feature_transformation} \tab Describes the given feature transformation\cr
#'  \link[=personalize_describe_filter]{describe_filter} \tab Describes a filter's properties\cr
#'  \link[=personalize_describe_recipe]{describe_recipe} \tab Describes a recipe\cr
#'  \link[=personalize_describe_schema]{describe_schema} \tab Describes a schema\cr
#'  \link[=personalize_describe_solution]{describe_solution} \tab Describes a solution\cr
#'  \link[=personalize_describe_solution_version]{describe_solution_version} \tab Describes a specific version of a solution\cr
#'  \link[=personalize_get_solution_metrics]{get_solution_metrics} \tab Gets the metrics for the specified solution version\cr
#'  \link[=personalize_list_batch_inference_jobs]{list_batch_inference_jobs} \tab Gets a list of the batch inference jobs that have been performed off of a solution version\cr
#'  \link[=personalize_list_campaigns]{list_campaigns} \tab Returns a list of campaigns that use the given solution\cr
#'  \link[=personalize_list_dataset_groups]{list_dataset_groups} \tab Returns a list of dataset groups\cr
#'  \link[=personalize_list_dataset_import_jobs]{list_dataset_import_jobs} \tab Returns a list of dataset import jobs that use the given dataset\cr
#'  \link[=personalize_list_datasets]{list_datasets} \tab Returns the list of datasets contained in the given dataset group\cr
#'  \link[=personalize_list_event_trackers]{list_event_trackers} \tab Returns the list of event trackers associated with the account\cr
#'  \link[=personalize_list_filters]{list_filters} \tab Lists all filters that belong to a given dataset group\cr
#'  \link[=personalize_list_recipes]{list_recipes} \tab Returns a list of available recipes\cr
#'  \link[=personalize_list_schemas]{list_schemas} \tab Returns the list of schemas associated with the account\cr
#'  \link[=personalize_list_solutions]{list_solutions} \tab Returns a list of solutions that use the given dataset group\cr
#'  \link[=personalize_list_solution_versions]{list_solution_versions} \tab Returns a list of solution versions for the given solution\cr
#'  \link[=personalize_update_campaign]{update_campaign} \tab Updates a campaign by either deploying a new solution or changing the value of the campaign's minProvisionedTPS parameter
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname personalize
#' @export
personalize <- function(config = list()) {
  svc <- .personalize$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.personalize <- list()

.personalize$operations <- list()

.personalize$metadata <- list(
  service_name = "personalize",
  endpoints = list("*" = list(endpoint = "personalize.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "personalize.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "personalize.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "personalize.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Personalize",
  api_version = "2018-05-22",
  signing_name = "personalize",
  json_version = "1.1",
  target_prefix = "AmazonPersonalize"
)

.personalize$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.personalize$metadata, handlers, config)
}
