% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_get_face_detection}
\alias{rekognition_get_face_detection}
\title{Gets face detection results for a Amazon Rekognition Video analysis
started by StartFaceDetection}
\usage{
rekognition_get_face_detection(JobId, MaxResults, NextToken)
}
\arguments{
\item{JobId}{[required] Unique identifier for the face detection job. The \code{JobId} is returned
from \code{StartFaceDetection}.}

\item{MaxResults}{Maximum number of results to return per paginated call. The largest
value you can specify is 1000. If you specify a value greater than 1000,
a maximum of 1000 results is returned. The default value is 1000.}

\item{NextToken}{If the previous response was incomplete (because there are more faces to
retrieve), Amazon Rekognition Video returns a pagination token in the
response. You can use this pagination token to retrieve the next set of
faces.}
}
\description{
Gets face detection results for a Amazon Rekognition Video analysis
started by StartFaceDetection.
}
\details{
Face detection with Amazon Rekognition Video is an asynchronous
operation. You start face detection by calling StartFaceDetection which
returns a job identifier (\code{JobId}). When the face detection operation
finishes, Amazon Rekognition Video publishes a completion status to the
Amazon Simple Notification Service topic registered in the initial call
to \code{StartFaceDetection}. To get the results of the face detection
operation, first check that the status value published to the Amazon SNS
topic is \code{SUCCEEDED}. If so, call GetFaceDetection and pass the job
identifier (\code{JobId}) from the initial call to \code{StartFaceDetection}.

\code{GetFaceDetection} returns an array of detected faces (\code{Faces}) sorted
by the time the faces were detected.

Use MaxResults parameter to limit the number of labels returned. If
there are more results than specified in \code{MaxResults}, the value of
\code{NextToken} in the operation response contains a pagination token for
getting the next set of results. To get the next page of results, call
\code{GetFaceDetection} and populate the \code{NextToken} request parameter with
the token value returned from the previous call to \code{GetFaceDetection}.
}
\section{Request syntax}{
\preformatted{svc$get_face_detection(
  JobId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
