% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_workteam}
\alias{sagemaker_update_workteam}
\title{Updates an existing work team with new member definitions or description}
\usage{
sagemaker_update_workteam(WorkteamName, MemberDefinitions, Description,
  NotificationConfiguration)
}
\arguments{
\item{WorkteamName}{[required] The name of the work team to update.}

\item{MemberDefinitions}{A list of \code{MemberDefinition} objects that contain the updated work team
members.}

\item{Description}{An updated description for the work team.}

\item{NotificationConfiguration}{Configures SNS topic notifications for available or expiring work items}
}
\description{
Updates an existing work team with new member definitions or
description.
}
\section{Request syntax}{
\preformatted{svc$update_workteam(
  WorkteamName = "string",
  MemberDefinitions = list(
    list(
      CognitoMemberDefinition = list(
        UserPool = "string",
        UserGroup = "string",
        ClientId = "string"
      )
    )
  ),
  Description = "string",
  NotificationConfiguration = list(
    NotificationTopicArn = "string"
  )
)
}
}

\keyword{internal}
