% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_images}
\alias{sagemaker_list_images}
\title{Lists the images in your account and their properties}
\usage{
sagemaker_list_images(
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  MaxResults = NULL,
  NameContains = NULL,
  NextToken = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only images created on or after the specified
time.}

\item{CreationTimeBefore}{A filter that returns only images created on or before the specified
time.}

\item{LastModifiedTimeAfter}{A filter that returns only images modified on or after the specified
time.}

\item{LastModifiedTimeBefore}{A filter that returns only images modified on or before the specified
time.}

\item{MaxResults}{The maximum number of images to return in the response. The default
value is 10.}

\item{NameContains}{A filter that returns only images whose name contains the specified
string.}

\item{NextToken}{If the previous call to \code{\link[=sagemaker_list_images]{list_images}} didn't
return the full set of images, the call returns a token for getting the
next set of images.}

\item{SortBy}{The property used to sort results. The default value is \code{CREATION_TIME}.}

\item{SortOrder}{The sort order. The default value is \code{DESCENDING}.}
}
\description{
Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.

See \url{https://paws-r.github.io/docs/sagemaker/list_images.html} for full documentation.
}
\keyword{internal}
