% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_domain}
\alias{sagemaker_update_domain}
\title{Updates the default settings for new user profiles in the domain}
\usage{
sagemaker_update_domain(
  DomainId,
  DefaultUserSettings = NULL,
  DomainSettingsForUpdate = NULL,
  DefaultSpaceSettings = NULL,
  AppSecurityGroupManagement = NULL
)
}
\arguments{
\item{DomainId}{[required] The ID of the domain to be updated.}

\item{DefaultUserSettings}{A collection of settings.}

\item{DomainSettingsForUpdate}{A collection of \code{DomainSettings} configuration values to update.}

\item{DefaultSpaceSettings}{The default settings used to create a space within the Domain.}

\item{AppSecurityGroupManagement}{The entity that creates and manages the required security groups for
inter-app communication in \code{VPCOnly} mode. Required when
\code{CreateDomain.AppNetworkAccessType} is \code{VPCOnly} and
\code{DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn}
is provided. If setting up the domain for use with RStudio, this value
must be set to \code{Service}.}
}
\description{
Updates the default settings for new user profiles in the domain.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_domain/} for full documentation.
}
\keyword{internal}
