% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_model_import_jobs}
\alias{bedrock_list_model_import_jobs}
\title{Returns a list of import jobs you've submitted}
\usage{
bedrock_list_model_import_jobs(
  creationTimeAfter = NULL,
  creationTimeBefore = NULL,
  statusEquals = NULL,
  nameContains = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{creationTimeAfter}{Return import jobs that were created after the specified time.}

\item{creationTimeBefore}{Return import jobs that were created before the specified time.}

\item{statusEquals}{Return imported jobs with the specified status.}

\item{nameContains}{Return imported jobs only if the job name contains these characters.}

\item{maxResults}{The maximum number of results to return in the response. If the total
number of results is greater than this value, use the token returned in
the response in the \code{nextToken} field when making another request to
return the next batch of results.}

\item{nextToken}{If the total number of results is greater than the \code{maxResults} value
provided in the request, enter the token returned in the \code{nextToken}
field in the response in this field to return the next batch of results.}

\item{sortBy}{The field to sort by in the returned list of imported jobs.}

\item{sortOrder}{Specifies whether to sort the results in ascending or descending order.}
}
\description{
Returns a list of import jobs you've submitted. You can filter the results to return based on one or more criteria. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html}{Import a customized model} in the \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Amazon Bedrock User Guide}.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_model_import_jobs/} for full documentation.
}
\keyword{internal}
