% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_create_launch_configuration}
\alias{autoscaling_create_launch_configuration}
\title{Creates a launch configuration}
\usage{
autoscaling_create_launch_configuration(LaunchConfigurationName,
  ImageId, KeyName, SecurityGroups, ClassicLinkVPCId,
  ClassicLinkVPCSecurityGroups, UserData, InstanceId, InstanceType,
  KernelId, RamdiskId, BlockDeviceMappings, InstanceMonitoring, SpotPrice,
  IamInstanceProfile, EbsOptimized, AssociatePublicIpAddress,
  PlacementTenancy)
}
\arguments{
\item{LaunchConfigurationName}{[required] The name of the launch configuration. This name must be unique within
the scope of your AWS account.}

\item{ImageId}{The ID of the Amazon Machine Image (AMI) to use to launch your EC2
instances.

If you do not specify \code{InstanceId}, you must specify \code{ImageId}.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html}{Finding an AMI}
in the \emph{Amazon EC2 User Guide for Linux Instances}.}

\item{KeyName}{The name of the key pair. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html}{Amazon EC2 Key Pairs}
in the \emph{Amazon EC2 User Guide for Linux Instances}.}

\item{SecurityGroups}{One or more security groups with which to associate the instances.

If your instances are launched in EC2-Classic, you can either specify
security group names or the security group IDs. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html}{Amazon EC2 Security Groups}
in the \emph{Amazon EC2 User Guide for Linux Instances}.

If your instances are launched into a VPC, specify security group IDs.
For more information, see \href{https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html}{Security Groups for Your VPC}
in the \emph{Amazon Virtual Private Cloud User Guide}.}

\item{ClassicLinkVPCId}{The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances
to. This parameter is supported only if you are launching EC2-Classic
instances. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html}{ClassicLink}
in the \emph{Amazon EC2 User Guide for Linux Instances} and \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink}{Linking EC2-Classic Instances to a VPC}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{ClassicLinkVPCSecurityGroups}{The IDs of one or more security groups for the specified
ClassicLink-enabled VPC. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html}{ClassicLink}
in the \emph{Amazon EC2 User Guide for Linux Instances} and \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink}{Linking EC2-Classic Instances to a VPC}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Conditional: This parameter is required if you specify a
ClassicLink-enabled VPC, and is not supported otherwise.}

\item{UserData}{The user data to make available to the launched EC2 instances. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Instance Metadata and User Data}
in the \emph{Amazon EC2 User Guide for Linux Instances}.}

\item{InstanceId}{The ID of the instance to use to create the launch configuration. The
new launch configuration derives attributes from the instance, except
for the block device mapping.

If you do not specify \code{InstanceId}, you must specify both \code{ImageId} and
\code{InstanceType}.

To create a launch configuration with a block device mapping or override
any other instance attributes, specify them as part of the same request.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html}{Create a Launch Configuration Using an EC2 Instance}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{InstanceType}{The instance type of the EC2 instance.

If you do not specify \code{InstanceId}, you must specify \code{InstanceType}.

For information about available instance types, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes}{Available Instance Types}
in the \emph{Amazon EC2 User Guide for Linux Instances.}}

\item{KernelId}{The ID of the kernel associated with the AMI.}

\item{RamdiskId}{The ID of the RAM disk associated with the AMI.}

\item{BlockDeviceMappings}{One or more mappings that specify how block devices are exposed to the
instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html}{Block Device Mapping}
in the \emph{Amazon EC2 User Guide for Linux Instances}.}

\item{InstanceMonitoring}{Enables detailed monitoring (\code{true}) or basic monitoring (\code{false}) for
the Auto Scaling instances. The default value is \code{true}.}

\item{SpotPrice}{The maximum hourly price to be paid for any Spot Instance launched to
fulfill the request. Spot Instances are launched when the price you
specify exceeds the current Spot market price. For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html}{Launching Spot Instances in Your Auto Scaling Group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{IamInstanceProfile}{The name or the Amazon Resource Name (ARN) of the instance profile
associated with the IAM role for the instance.

EC2 instances launched with an IAM role automatically have AWS security
credentials available. You can use IAM roles with Amazon EC2 Auto
Scaling to automatically enable applications running on your EC2
instances to securely access other AWS resources. For more information,
see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html}{Use an IAM Role for Applications That Run on Amazon EC2 Instances}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{EbsOptimized}{Indicates whether the instance is optimized for Amazon EBS I/O. By
default, the instance is not optimized for EBS I/O. The optimization
provides dedicated throughput to Amazon EBS and an optimized
configuration stack to provide optimal I/O performance. This
optimization is not available with all instance types. Additional usage
charges apply. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html}{Amazon EBS-Optimized Instances}
in the \emph{Amazon EC2 User Guide for Linux Instances}.}

\item{AssociatePublicIpAddress}{Used for groups that launch instances into a virtual private cloud
(VPC). Specifies whether to assign a public IP address to each instance.
For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html}{Launching Auto Scaling Instances in a VPC}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

If you specify this parameter, be sure to specify at least one subnet
when you create your group.

Default: If the instance is launched into a default subnet, the default
is to assign a public IP address. If the instance is launched into a
nondefault subnet, the default is not to assign a public IP address.}

\item{PlacementTenancy}{The tenancy of the instance. An instance with a tenancy of \code{dedicated}
runs on single-tenant hardware and can only be launched into a VPC.

To launch Dedicated Instances into a shared tenancy VPC (a VPC with the
instance placement tenancy attribute set to \code{default}), you must set the
value of this parameter to \code{dedicated}.

If you specify this parameter, be sure to specify at least one subnet
when you create your group.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html}{Launching Auto Scaling Instances in a VPC}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Valid values: \code{default} \| \code{dedicated}}
}
\description{
Creates a launch configuration.
}
\details{
If you exceed your maximum limit of launch configurations, the call
fails. For information about viewing this limit, see
DescribeAccountLimits. For information about updating this limit, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html}{Amazon EC2 Auto Scaling Limits}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html}{Launch Configurations}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_launch_configuration(
  LaunchConfigurationName = "string",
  ImageId = "string",
  KeyName = "string",
  SecurityGroups = list(
    "string"
  ),
  ClassicLinkVPCId = "string",
  ClassicLinkVPCSecurityGroups = list(
    "string"
  ),
  UserData = "string",
  InstanceId = "string",
  InstanceType = "string",
  KernelId = "string",
  RamdiskId = "string",
  BlockDeviceMappings = list(
    list(
      VirtualName = "string",
      DeviceName = "string",
      Ebs = list(
        SnapshotId = "string",
        VolumeSize = 123,
        VolumeType = "string",
        DeleteOnTermination = TRUE|FALSE,
        Iops = 123,
        Encrypted = TRUE|FALSE
      ),
      NoDevice = TRUE|FALSE
    )
  ),
  InstanceMonitoring = list(
    Enabled = TRUE|FALSE
  ),
  SpotPrice = "string",
  IamInstanceProfile = "string",
  EbsOptimized = TRUE|FALSE,
  AssociatePublicIpAddress = TRUE|FALSE,
  PlacementTenancy = "string"
)
}
}

\examples{
# This example creates a launch configuration.
\donttest{svc$create_launch_configuration(
  IamInstanceProfile = "my-iam-role",
  ImageId = "ami-12345678",
  InstanceType = "m3.medium",
  LaunchConfigurationName = "my-launch-config",
  SecurityGroups = list(
    "sg-eb2af88e"
  )
)}

}
\keyword{internal}
