% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_update_stack_set}
\alias{cloudformation_update_stack_set}
\title{Updates the stack set, and associated stack instances in the specified
accounts and regions}
\usage{
cloudformation_update_stack_set(StackSetName, Description, TemplateBody,
  TemplateURL, UsePreviousTemplate, Parameters, Capabilities, Tags,
  OperationPreferences, AdministrationRoleARN, ExecutionRoleName,
  OperationId, Accounts, Regions)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set that you want to update.}

\item{Description}{A brief description of updates that you are making.}

\item{TemplateBody}{The structure that contains the template body, with a minimum length of
1 byte and a maximum length of 51,200 bytes. For more information, see
\href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify only one of the following parameters:
\code{TemplateBody} or \code{TemplateURL}---or set \code{UsePreviousTemplate} to true.}

\item{TemplateURL}{The location of the file that contains the template body. The URL must
point to a template (maximum size: 460,800 bytes) that is located in an
Amazon S3 bucket. For more information, see \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify only one of the following parameters:
\code{TemplateBody} or \code{TemplateURL}---or set \code{UsePreviousTemplate} to true.}

\item{UsePreviousTemplate}{Use the existing template that's associated with the stack set that
you're updating.

Conditional: You must specify only one of the following parameters:
\code{TemplateBody} or \code{TemplateURL}---or set \code{UsePreviousTemplate} to true.}

\item{Parameters}{A list of input parameters for the stack set template.}

\item{Capabilities}{In some cases, you must explicity acknowledge that your stack template
contains certain capabilities in order for AWS CloudFormation to update
the stack set and its associated stack instances.
\itemize{
\item \code{CAPABILITY_IAM} and \code{CAPABILITY_NAMED_IAM}

Some stack templates might include resources that can affect
permissions in your AWS account; for example, by creating new AWS
Identity and Access Management (IAM) users. For those stacks sets,
you must explicitly acknowledge this by specifying one of these
capabilities.

The following IAM resources require you to specify either the
\code{CAPABILITY_IAM} or \code{CAPABILITY_NAMED_IAM} capability.
\itemize{
\item If you have IAM resources, you can specify either capability.
\item If you have IAM resources with custom names, you \emph{must} specify
\code{CAPABILITY_NAMED_IAM}.
\item If you don't specify either of these capabilities, AWS
CloudFormation returns an \code{InsufficientCapabilities} error.
}

If your stack template contains these resources, we recommend that
you review all permissions associated with them and edit their
permissions if necessary.
\itemize{
\item \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html}{AWS::IAM::AccessKey}
\item \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html}{AWS::IAM::Group}
\item \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html}{AWS::IAM::InstanceProfile}
\item \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html}{AWS::IAM::Policy}
\item \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html}{AWS::IAM::Role}
\item \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html}{AWS::IAM::User}
\item \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html}{AWS::IAM::UserToGroupAddition}
}

For more information, see \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities}{Acknowledging IAM Resources in AWS CloudFormation Templates}.
\item \code{CAPABILITY_AUTO_EXPAND}

Some templates contain macros. If your stack template contains one
or more macros, and you choose to update a stack directly from the
processed template, without first reviewing the resulting changes in
a change set, you must acknowledge this capability. For more
information, see \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html}{Using AWS CloudFormation Macros to Perform Custom Processing on Templates}.

Stack sets do not currently support macros in stack templates. (This
includes the
\href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html}{AWS::Include}
and
\href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html}{AWS::Serverless}
transforms, which are macros hosted by AWS CloudFormation.) Even if
you specify this capability, if you include a macro in your template
the stack set operation will fail.
}}

\item{Tags}{The key-value pairs to associate with this stack set and the stacks
created from it. AWS CloudFormation also propagates these tags to
supported resources that are created in the stacks. You can specify a
maximum number of 50 tags.

If you specify tags for this parameter, those tags replace any list of
tags that are currently associated with this stack set. This means:
\itemize{
\item If you don't specify this parameter, AWS CloudFormation doesn't
modify the stack's tags.
\item If you specify \emph{any} tags using this parameter, you must specify
\emph{all} the tags that you want associated with this stack set, even
tags you've specifed before (for example, when creating the stack
set or during a previous update of the stack set.). Any tags that
you don't include in the updated list of tags are removed from the
stack set, and therefore from the stacks and resources as well.
\item If you specify an empty value, AWS CloudFormation removes all
currently associated tags.
}

If you specify new tags as part of an \code{UpdateStackSet} action, AWS
CloudFormation checks to see if you have the required IAM permission to
tag resources. If you omit tags that are currently associated with the
stack set from the list of tags you specify, AWS CloudFormation assumes
that you want to remove those tags from the stack set, and checks to see
if you have permission to untag resources. If you don't have the
necessary permission(s), the entire \code{UpdateStackSet} action fails with
an \code{access denied} error, and the stack set is not updated.}

\item{OperationPreferences}{Preferences for how AWS CloudFormation performs this stack set
operation.}

\item{AdministrationRoleARN}{The Amazon Resource Number (ARN) of the IAM role to use to update this
stack set.

Specify an IAM role only if you are using customized administrator roles
to control which users or groups can manage specific stack sets within
the same administrator account. For more information, see \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html}{Define Permissions for Multiple Administrators}
in the \emph{AWS CloudFormation User Guide}.

If you specify a customized administrator role, AWS CloudFormation uses
that role to update the stack. If you do not specify a customized
administrator role, AWS CloudFormation performs the update using the
role previously associated with the stack set, so long as you have
permissions to perform operations on the stack set.}

\item{ExecutionRoleName}{The name of the IAM execution role to use to update the stack set. If
you do not specify an execution role, AWS CloudFormation uses the
\code{AWSCloudFormationStackSetExecutionRole} role for the stack set
operation.

Specify an IAM role only if you are using customized execution roles to
control which stack resources users and groups can include in their
stack sets.

If you specify a customized execution role, AWS CloudFormation uses that
role to update the stack. If you do not specify a customized execution
role, AWS CloudFormation performs the update using the role previously
associated with the stack set, so long as you have permissions to
perform operations on the stack set.}

\item{OperationId}{The unique ID for this stack set operation.

The operation ID also functions as an idempotency token, to ensure that
AWS CloudFormation performs the stack set operation only once, even if
you retry the request multiple times. You might retry stack set
operation requests to ensure that AWS CloudFormation successfully
received them.

If you don't specify an operation ID, AWS CloudFormation generates one
automatically.

Repeating this stack set operation with a new operation ID retries all
stack instances whose status is \code{OUTDATED}.}

\item{Accounts}{The accounts in which to update associated stack instances. If you
specify accounts, you must also specify the regions in which to update
stack set instances.

To update \emph{all} the stack instances associated with this stack set, do
not specify the \code{Accounts} or \code{Regions} properties.

If the stack set update includes changes to the template (that is, if
the \code{TemplateBody} or \code{TemplateURL} properties are specified), or the
\code{Parameters} property, AWS CloudFormation marks all stack instances with
a status of \code{OUTDATED} prior to updating the stack instances in the
specified accounts and regions. If the stack set update does not include
changes to the template or parameters, AWS CloudFormation updates the
stack instances in the specified accounts and regions, while leaving all
other stack instances with their existing stack instance status.}

\item{Regions}{The regions in which to update associated stack instances. If you
specify regions, you must also specify accounts in which to update stack
set instances.

To update \emph{all} the stack instances associated with this stack set, do
not specify the \code{Accounts} or \code{Regions} properties.

If the stack set update includes changes to the template (that is, if
the \code{TemplateBody} or \code{TemplateURL} properties are specified), or the
\code{Parameters} property, AWS CloudFormation marks all stack instances with
a status of \code{OUTDATED} prior to updating the stack instances in the
specified accounts and regions. If the stack set update does not include
changes to the template or parameters, AWS CloudFormation updates the
stack instances in the specified accounts and regions, while leaving all
other stack instances with their existing stack instance status.}
}
\description{
Updates the stack set, and associated stack instances in the specified
accounts and regions.
}
\details{
Even if the stack set operation created by updating the stack set fails
(completely or partially, below or above a specified failure tolerance),
the stack set is updated with your changes. Subsequent
CreateStackInstances calls on the specified stack set use the updated
stack set.
}
\section{Request syntax}{
\preformatted{svc$update_stack_set(
  StackSetName = "string",
  Description = "string",
  TemplateBody = "string",
  TemplateURL = "string",
  UsePreviousTemplate = TRUE|FALSE,
  Parameters = list(
    list(
      ParameterKey = "string",
      ParameterValue = "string",
      UsePreviousValue = TRUE|FALSE,
      ResolvedValue = "string"
    )
  ),
  Capabilities = list(
    "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  OperationPreferences = list(
    RegionOrder = list(
      "string"
    ),
    FailureToleranceCount = 123,
    FailureTolerancePercentage = 123,
    MaxConcurrentCount = 123,
    MaxConcurrentPercentage = 123
  ),
  AdministrationRoleARN = "string",
  ExecutionRoleName = "string",
  OperationId = "string",
  Accounts = list(
    "string"
  ),
  Regions = list(
    "string"
  )
)
}
}

\keyword{internal}
