% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_received_grants}
\alias{licensemanager_list_received_grants}
\title{Lists grants that are received but not accepted}
\usage{
licensemanager_list_received_grants(GrantArns, Filters, NextToken,
  MaxResults)
}
\arguments{
\item{GrantArns}{Amazon Resource Names (ARNs) of the grants.}

\item{Filters}{Filters to scope the results. The following filters are supported:
\itemize{
\item \code{LicenseARN}
\item \code{Status}
}}

\item{NextToken}{Token for the next set of results.}

\item{MaxResults}{Maximum number of results to return in a single call.}
}
\value{
A list with the following syntax:\preformatted{list(
  Grants = list(
    list(
      GrantArn = "string",
      GrantName = "string",
      ParentArn = "string",
      LicenseArn = "string",
      GranteePrincipalArn = "string",
      HomeRegion = "string",
      GrantStatus = "PENDING_WORKFLOW"|"PENDING_ACCEPT"|"REJECTED"|"ACTIVE"|"FAILED_WORKFLOW"|"DELETED"|"PENDING_DELETE"|"DISABLED",
      StatusReason = "string",
      Version = "string",
      GrantedOperations = list(
        "CreateGrant"|"CheckoutLicense"|"CheckoutBorrowLicense"|"CheckInLicense"|"ExtendConsumptionLicense"|"ListPurchasedLicenses"|"CreateToken"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists grants that are received but not accepted.
}
\section{Request syntax}{
\preformatted{svc$list_received_grants(
  GrantArns = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
