# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS License Manager
#'
#' @description
#' *This is the AWS License Manager API Reference.* It provides
#' descriptions, syntax, and usage examples for each of the actions and
#' data types for License Manager. The topic for each action shows the
#' Query API request parameters and the XML response. You can also view the
#' XML request elements in the WSDL.
#' 
#' Alternatively, you can use one of the AWS SDKs to access an API that\'s
#' tailored to the programming language or platform that you\'re using. For
#' more information, see [AWS SDKs](http://aws.amazon.com/tools/#SDKs).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- licensemanager(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- licensemanager()
#' svc$create_license_configuration(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=licensemanager_create_license_configuration]{create_license_configuration} \tab Creates a new license configuration object \cr
#'  \link[=licensemanager_delete_license_configuration]{delete_license_configuration} \tab Deletes an existing license configuration \cr
#'  \link[=licensemanager_get_license_configuration]{get_license_configuration} \tab Returns a detailed description of a license configuration \cr
#'  \link[=licensemanager_get_service_settings]{get_service_settings} \tab Gets License Manager settings for a region \cr
#'  \link[=licensemanager_list_associations_for_license_configuration]{list_associations_for_license_configuration} \tab Lists the resource associations for a license configuration \cr
#'  \link[=licensemanager_list_license_configurations]{list_license_configurations} \tab Lists license configuration objects for an account, each containing the name, description, license type, and other license terms modeled from a license agreement\cr
#'  \link[=licensemanager_list_license_specifications_for_resource]{list_license_specifications_for_resource} \tab Returns the license configuration for a resource \cr
#'  \link[=licensemanager_list_resource_inventory]{list_resource_inventory} \tab Returns a detailed list of resources \cr
#'  \link[=licensemanager_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags attached to a resource \cr
#'  \link[=licensemanager_list_usage_for_license_configuration]{list_usage_for_license_configuration} \tab Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time \cr
#'  \link[=licensemanager_tag_resource]{tag_resource} \tab Attach one of more tags to any resource \cr
#'  \link[=licensemanager_untag_resource]{untag_resource} \tab Remove tags from a resource \cr
#'  \link[=licensemanager_update_license_configuration]{update_license_configuration} \tab Modifies the attributes of an existing license configuration object \cr
#'  \link[=licensemanager_update_license_specifications_for_resource]{update_license_specifications_for_resource} \tab Adds or removes license configurations for a specified AWS resource \cr
#'  \link[=licensemanager_update_service_settings]{update_service_settings} \tab Updates License Manager service settings 
#' }
#'
#' @rdname licensemanager
#' @export
licensemanager <- function(config = list()) {
  svc <- .licensemanager$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.licensemanager <- list()

.licensemanager$operations <- list()

.licensemanager$metadata <- list(
  service_name = "licensemanager",
  endpoints = list("*" = list(endpoint = "licensemanager.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "licensemanager.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "License Manager",
  api_version = "2018-08-01",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSLicenseManager"
)

.licensemanager$handlers <- new_handlers("jsonrpc", "v4")

.licensemanager$service <- function(config = list()) {
  new_service(.licensemanager$metadata, .licensemanager$handlers, config)
}
