% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_association}
\alias{ssm_update_association}
\title{Updates an association}
\usage{
ssm_update_association(AssociationId, Parameters, DocumentVersion,
  ScheduleExpression, OutputLocation, Name, Targets, AssociationName,
  AssociationVersion, AutomationTargetParameterName, MaxErrors,
  MaxConcurrency, ComplianceSeverity)
}
\arguments{
\item{AssociationId}{[required] The ID of the association you want to update.}

\item{Parameters}{The parameters you want to update for the association. If you create a
parameter using Parameter Store, you can reference the parameter using
{{ssm:parameter-name}}}

\item{DocumentVersion}{The document version you want update for the association.}

\item{ScheduleExpression}{The cron expression used to schedule the association that you want to
update.}

\item{OutputLocation}{An Amazon S3 bucket where you want to store the results of this request.}

\item{Name}{The name of the SSM document that contains the configuration information
for the instance. You can specify Command or Automation documents.

You can specify AWS-predefined documents, documents you created, or a
document that is shared with you from another account.

For SSM documents that are shared with you from other AWS accounts, you
must specify the complete SSM document ARN, in the following format:

\code{arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> }

For example:

\code{arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document}

For AWS-predefined documents and SSM documents you created in your
account, you only need to specify the document name. For example,
\code{AWS-ApplyPatchBaseline} or \code{My-Document}.}

\item{Targets}{The targets of the association.}

\item{AssociationName}{The name of the association that you want to update.}

\item{AssociationVersion}{This parameter is provided for concurrency control purposes. You must
specify the latest association version in the service. If you want to
ensure that this request succeeds, either specify \code{$LATEST}, or omit
this parameter.}

\item{AutomationTargetParameterName}{Specify the target for the association. This target is required for
associations that use an Automation document and target resources by
using rate controls.}

\item{MaxErrors}{The number of errors that are allowed before the system stops sending
requests to run the association on additional targets. You can specify
either an absolute number of errors, for example 10, or a percentage of
the target set, for example 10\%. If you specify 3, for example, the
system stops sending requests when the fourth error is received. If you
specify 0, then the system stops sending requests after the first error
is returned. If you run an association on 50 instances and set MaxError
to 10\%, then the system stops sending the request when the sixth error
is received.

Executions that are already running an association when MaxErrors is
reached are allowed to complete, but some of these executions may fail
as well. If you need to ensure that there won't be more than max-errors
failed executions, set MaxConcurrency to 1 so that executions proceed
one at a time.}

\item{MaxConcurrency}{The maximum number of targets allowed to run the association at the same
time. You can specify a number, for example 10, or a percentage of the
target set, for example 10\%. The default value is 100\%, which means all
targets run the association at the same time.

If a new instance starts and attempts to run an association while
Systems Manager is running MaxConcurrency associations, the association
is allowed to run. During the next association interval, the new
instance will process its association within the limit specified for
MaxConcurrency.}

\item{ComplianceSeverity}{The severity level to assign to the association.}
}
\description{
Updates an association. You can update the association name and version,
the document version, schedule, parameters, and Amazon S3 output.
}
\details{
When you update an association, the association immediately runs against
the specified targets.
}
\section{Request syntax}{
\preformatted{svc$update_association(
  AssociationId = "string",
  Parameters = list(
    list(
      "string"
    )
  ),
  DocumentVersion = "string",
  ScheduleExpression = "string",
  OutputLocation = list(
    S3Location = list(
      OutputS3Region = "string",
      OutputS3BucketName = "string",
      OutputS3KeyPrefix = "string"
    )
  ),
  Name = "string",
  Targets = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  AssociationName = "string",
  AssociationVersion = "string",
  AutomationTargetParameterName = "string",
  MaxErrors = "string",
  MaxConcurrency = "string",
  ComplianceSeverity = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"UNSPECIFIED"
)
}
}

\keyword{internal}
