% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_list_groups}
\alias{resourcegroups_list_groups}
\title{Returns a list of existing resource groups in your account}
\usage{
resourcegroups_list_groups(Filters, MaxResults, NextToken)
}
\arguments{
\item{Filters}{Filters, formatted as GroupFilter objects, that you want to apply to a
ListGroups operation.
\itemize{
\item \code{resource-type} - Filter groups by resource type. Specify up to five
resource types in the format AWS::ServiceCode::ResourceType. For
example, AWS::EC2::Instance, or AWS::S3::Bucket.
}}

\item{MaxResults}{The maximum number of resource group results that are returned by
ListGroups in paginated output. By default, this number is 50.}

\item{NextToken}{The NextToken value that is returned in a paginated \code{ListGroups}
request. To get the next page of results, run the call again, add the
NextToken parameter, and specify the NextToken value.}
}
\description{
Returns a list of existing resource groups in your account.
}
\section{Request syntax}{
\preformatted{svc$list_groups(
  Filters = list(
    list(
      Name = "resource-type",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
