% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_log_events}
\alias{cloudwatchlogs_put_log_events}
\title{Uploads a batch of log events to the specified log stream}
\usage{
cloudwatchlogs_put_log_events(
  logGroupName,
  logStreamName,
  logEvents,
  sequenceToken = NULL
)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{logStreamName}{[required] The name of the log stream.}

\item{logEvents}{[required] The log events.}

\item{sequenceToken}{The sequence token obtained from the response of the previous
\code{\link[=cloudwatchlogs_put_log_events]{put_log_events}} call. An upload in a
newly created log stream does not require a sequence token. You can also
get the sequence token using
\code{\link[=cloudwatchlogs_describe_log_streams]{describe_log_streams}}. If you
call \code{\link[=cloudwatchlogs_put_log_events]{put_log_events}} twice within a
narrow time period using the same value for \code{sequenceToken}, both calls
might be successful or one might be rejected.}
}
\description{
Uploads a batch of log events to the specified log stream.

See \url{https://paws-r.github.io/docs/cloudwatchlogs/put_log_events.html} for full documentation.
}
\keyword{internal}
