% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_list_conformance_pack_compliance_scores}
\alias{configservice_list_conformance_pack_compliance_scores}
\title{Returns a list of conformance pack compliance scores}
\usage{
configservice_list_conformance_pack_compliance_scores(
  Filters = NULL,
  SortOrder = NULL,
  SortBy = NULL,
  Limit = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Filters}{Filters the results based on the
\code{ConformancePackComplianceScoresFilters}.}

\item{SortOrder}{Determines the order in which conformance pack compliance scores are
sorted. Either in ascending or descending order.

Conformance packs with a compliance score of \code{INSUFFICIENT_DATA} will be
first when sorting by ascending order and last when sorting by
descending order.}

\item{SortBy}{Sorts your conformance pack compliance scores in either ascending or
descending order, depending on \code{SortOrder}.

By default, conformance pack compliance scores are sorted in ascending
order by compliance score and alphabetically by name of the conformance
pack if there is more than one conformance pack with the same compliance
score.}

\item{Limit}{The maximum number of conformance pack compliance scores returned on
each page.}

\item{NextToken}{The \code{nextToken} string in a prior request that you can use to get the
paginated response for next set of conformance pack compliance scores.}
}
\description{
Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of your conformance packs, and can be used to identify, investigate, and understand the level of compliance in your conformance packs.

See \url{https://paws-r.github.io/docs/configservice/list_conformance_pack_compliance_scores.html} for full documentation.
}
\keyword{internal}
