% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_patch_properties}
\alias{ssm_describe_patch_properties}
\title{Lists the properties of available patches organized by product, product
family, classification, severity, and other properties of available
patches}
\usage{
ssm_describe_patch_properties(
  OperatingSystem,
  Property,
  PatchSet = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{OperatingSystem}{[required] The operating system type for which to list patches.}

\item{Property}{[required] The patch property for which you want to view patch details.}

\item{PatchSet}{Indicates whether to list patches for the Windows operating system or
for applications released by Microsoft. Not applicable for the Linux or
macOS operating systems.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches. You can use the reported properties in the filters you specify in requests for operations such as \code{\link[=ssm_create_patch_baseline]{create_patch_baseline}}, \code{\link[=ssm_update_patch_baseline]{update_patch_baseline}}, \code{\link[=ssm_describe_available_patches]{describe_available_patches}}, and \code{\link[=ssm_describe_patch_baselines]{describe_patch_baselines}}.

See \url{https://paws-r.github.io/docs/ssm/describe_patch_properties.html} for full documentation.
}
\keyword{internal}
