# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include licensemanagerusersubscriptions_service.R
NULL

#' Associates the user to an EC2 instance to utilize user-based
#' subscriptions
#'
#' @description
#' Associates the user to an EC2 instance to utilize user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_associate_user/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_associate_user/) for full documentation.
#'
#' @param Domain The domain name of the user.
#' @param IdentityProvider &#91;required&#93; The identity provider of the user.
#' @param InstanceId &#91;required&#93; The ID of the EC2 instance, which provides user-based subscriptions.
#' @param Username &#91;required&#93; The user name from the identity provider for the user.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_associate_user
licensemanagerusersubscriptions_associate_user <- function(Domain = NULL, IdentityProvider, InstanceId, Username) {
  op <- new_operation(
    name = "AssociateUser",
    http_method = "POST",
    http_path = "/user/AssociateUser",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$associate_user_input(Domain = Domain, IdentityProvider = IdentityProvider, InstanceId = InstanceId, Username = Username)
  output <- .licensemanagerusersubscriptions$associate_user_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$associate_user <- licensemanagerusersubscriptions_associate_user

#' Deregisters the identity provider from providing user-based
#' subscriptions
#'
#' @description
#' Deregisters the identity provider from providing user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_deregister_identity_provider/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_deregister_identity_provider/) for full documentation.
#'
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_deregister_identity_provider
licensemanagerusersubscriptions_deregister_identity_provider <- function(IdentityProvider, Product) {
  op <- new_operation(
    name = "DeregisterIdentityProvider",
    http_method = "POST",
    http_path = "/identity-provider/DeregisterIdentityProvider",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$deregister_identity_provider_input(IdentityProvider = IdentityProvider, Product = Product)
  output <- .licensemanagerusersubscriptions$deregister_identity_provider_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$deregister_identity_provider <- licensemanagerusersubscriptions_deregister_identity_provider

#' Disassociates the user from an EC2 instance providing user-based
#' subscriptions
#'
#' @description
#' Disassociates the user from an EC2 instance providing user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_disassociate_user/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_disassociate_user/) for full documentation.
#'
#' @param Domain The domain name of the user.
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param InstanceId &#91;required&#93; The ID of the EC2 instance, which provides user-based subscriptions.
#' @param Username &#91;required&#93; The user name from the identity provider for the user.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_disassociate_user
licensemanagerusersubscriptions_disassociate_user <- function(Domain = NULL, IdentityProvider, InstanceId, Username) {
  op <- new_operation(
    name = "DisassociateUser",
    http_method = "POST",
    http_path = "/user/DisassociateUser",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$disassociate_user_input(Domain = Domain, IdentityProvider = IdentityProvider, InstanceId = InstanceId, Username = Username)
  output <- .licensemanagerusersubscriptions$disassociate_user_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$disassociate_user <- licensemanagerusersubscriptions_disassociate_user

#' Lists the identity providers for user-based subscriptions
#'
#' @description
#' Lists the identity providers for user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_identity_providers/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_identity_providers/) for full documentation.
#'
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_identity_providers
licensemanagerusersubscriptions_list_identity_providers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIdentityProviders",
    http_method = "POST",
    http_path = "/identity-provider/ListIdentityProviders",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$list_identity_providers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerusersubscriptions$list_identity_providers_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_identity_providers <- licensemanagerusersubscriptions_list_identity_providers

#' Lists the EC2 instances providing user-based subscriptions
#'
#' @description
#' Lists the EC2 instances providing user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_instances/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_instances/) for full documentation.
#'
#' @param Filters An array of structures that you can use to filter the results to those
#' that match one or more sets of key-value pairs that you specify.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_instances
licensemanagerusersubscriptions_list_instances <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "POST",
    http_path = "/instance/ListInstances",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$list_instances_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerusersubscriptions$list_instances_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_instances <- licensemanagerusersubscriptions_list_instances

#' Lists the user-based subscription products available from an identity
#' provider
#'
#' @description
#' Lists the user-based subscription products available from an identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_product_subscriptions/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_product_subscriptions/) for full documentation.
#'
#' @param Filters An array of structures that you can use to filter the results to those
#' that match one or more sets of key-value pairs that you specify.
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_product_subscriptions
licensemanagerusersubscriptions_list_product_subscriptions <- function(Filters = NULL, IdentityProvider, MaxResults = NULL, NextToken = NULL, Product) {
  op <- new_operation(
    name = "ListProductSubscriptions",
    http_method = "POST",
    http_path = "/user/ListProductSubscriptions",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$list_product_subscriptions_input(Filters = Filters, IdentityProvider = IdentityProvider, MaxResults = MaxResults, NextToken = NextToken, Product = Product)
  output <- .licensemanagerusersubscriptions$list_product_subscriptions_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_product_subscriptions <- licensemanagerusersubscriptions_list_product_subscriptions

#' Lists user associations for an identity provider
#'
#' @description
#' Lists user associations for an identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_user_associations/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_list_user_associations/) for full documentation.
#'
#' @param Filters An array of structures that you can use to filter the results to those
#' that match one or more sets of key-value pairs that you specify.
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param InstanceId &#91;required&#93; The ID of the EC2 instance, which provides user-based subscriptions.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_list_user_associations
licensemanagerusersubscriptions_list_user_associations <- function(Filters = NULL, IdentityProvider, InstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUserAssociations",
    http_method = "POST",
    http_path = "/user/ListUserAssociations",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$list_user_associations_input(Filters = Filters, IdentityProvider = IdentityProvider, InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerusersubscriptions$list_user_associations_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$list_user_associations <- licensemanagerusersubscriptions_list_user_associations

#' Registers an identity provider for user-based subscriptions
#'
#' @description
#' Registers an identity provider for user-based subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_register_identity_provider/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_register_identity_provider/) for full documentation.
#'
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#' @param Settings The registered identity provider’s product related configuration
#' settings such as the subnets to provision VPC endpoints.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_register_identity_provider
licensemanagerusersubscriptions_register_identity_provider <- function(IdentityProvider, Product, Settings = NULL) {
  op <- new_operation(
    name = "RegisterIdentityProvider",
    http_method = "POST",
    http_path = "/identity-provider/RegisterIdentityProvider",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$register_identity_provider_input(IdentityProvider = IdentityProvider, Product = Product, Settings = Settings)
  output <- .licensemanagerusersubscriptions$register_identity_provider_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$register_identity_provider <- licensemanagerusersubscriptions_register_identity_provider

#' Starts a product subscription for a user with the specified identity
#' provider
#'
#' @description
#' Starts a product subscription for a user with the specified identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_start_product_subscription/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_start_product_subscription/) for full documentation.
#'
#' @param Domain The domain name of the user.
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#' @param Username &#91;required&#93; The user name from the identity provider of the user.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_start_product_subscription
licensemanagerusersubscriptions_start_product_subscription <- function(Domain = NULL, IdentityProvider, Product, Username) {
  op <- new_operation(
    name = "StartProductSubscription",
    http_method = "POST",
    http_path = "/user/StartProductSubscription",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$start_product_subscription_input(Domain = Domain, IdentityProvider = IdentityProvider, Product = Product, Username = Username)
  output <- .licensemanagerusersubscriptions$start_product_subscription_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$start_product_subscription <- licensemanagerusersubscriptions_start_product_subscription

#' Stops a product subscription for a user with the specified identity
#' provider
#'
#' @description
#' Stops a product subscription for a user with the specified identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_stop_product_subscription/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_stop_product_subscription/) for full documentation.
#'
#' @param Domain The domain name of the user.
#' @param IdentityProvider &#91;required&#93; An object that specifies details for the identity provider.
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#' @param Username &#91;required&#93; The user name from the identity provider for the user.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_stop_product_subscription
licensemanagerusersubscriptions_stop_product_subscription <- function(Domain = NULL, IdentityProvider, Product, Username) {
  op <- new_operation(
    name = "StopProductSubscription",
    http_method = "POST",
    http_path = "/user/StopProductSubscription",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$stop_product_subscription_input(Domain = Domain, IdentityProvider = IdentityProvider, Product = Product, Username = Username)
  output <- .licensemanagerusersubscriptions$stop_product_subscription_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$stop_product_subscription <- licensemanagerusersubscriptions_stop_product_subscription

#' Updates additional product configuration settings for the registered
#' identity provider
#'
#' @description
#' Updates additional product configuration settings for the registered identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_update_identity_provider_settings/](https://www.paws-r-sdk.com/docs/licensemanagerusersubscriptions_update_identity_provider_settings/) for full documentation.
#'
#' @param IdentityProvider &#91;required&#93; 
#' @param Product &#91;required&#93; The name of the user-based subscription product.
#' @param UpdateSettings &#91;required&#93; Updates the registered identity provider’s product related configuration
#' settings. You can update any combination of settings in a single
#' operation such as the:
#' 
#' -   Subnets which you want to add to provision VPC endpoints.
#' 
#' -   Subnets which you want to remove the VPC endpoints from.
#' 
#' -   Security group ID which permits traffic to the VPC endpoints.
#'
#' @keywords internal
#'
#' @rdname licensemanagerusersubscriptions_upd_ide_pro_set
licensemanagerusersubscriptions_update_identity_provider_settings <- function(IdentityProvider, Product, UpdateSettings) {
  op <- new_operation(
    name = "UpdateIdentityProviderSettings",
    http_method = "POST",
    http_path = "/identity-provider/UpdateIdentityProviderSettings",
    paginator = list()
  )
  input <- .licensemanagerusersubscriptions$update_identity_provider_settings_input(IdentityProvider = IdentityProvider, Product = Product, UpdateSettings = UpdateSettings)
  output <- .licensemanagerusersubscriptions$update_identity_provider_settings_output()
  config <- get_config()
  svc <- .licensemanagerusersubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerusersubscriptions$operations$update_identity_provider_settings <- licensemanagerusersubscriptions_update_identity_provider_settings
