% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_create_kx_cluster}
\alias{finspace_create_kx_cluster}
\title{Creates a new kdb cluster}
\usage{
finspace_create_kx_cluster(
  clientToken = NULL,
  environmentId,
  clusterName,
  clusterType,
  databases = NULL,
  cacheStorageConfigurations = NULL,
  autoScalingConfiguration = NULL,
  clusterDescription = NULL,
  capacityConfiguration,
  releaseLabel,
  vpcConfiguration = NULL,
  initializationScript = NULL,
  commandLineArguments = NULL,
  code = NULL,
  executionRole = NULL,
  savedownStorageConfiguration = NULL,
  azMode,
  availabilityZoneId = NULL,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{environmentId}{[required] A unique identifier for the kdb environment.}

\item{clusterName}{[required] A unique name for the cluster that you want to create.}

\item{clusterType}{[required] Specifies the type of KDB database that is being created. The following
types are available:
\itemize{
\item HDB – A Historical Database. The data is only accessible with
read-only permissions from one of the FinSpace managed kdb databases
mounted to the cluster.
\item RDB – A Realtime Database. This type of database captures all the
data from a ticker plant and stores it in memory until the end of
day, after which it writes all of its data to a disk and reloads the
HDB. This cluster type requires local storage for temporary storage
of data during the savedown process. If you specify this field in
your request, you must provide the \code{savedownStorageConfiguration}
parameter.
\item GATEWAY – A gateway cluster allows you to access data across
processes in kdb systems. It allows you to create your own routing
logic using the initialization scripts and custom code. This type of
cluster does not require a writable local storage.
}}

\item{databases}{A list of databases that will be available for querying.}

\item{cacheStorageConfigurations}{The configurations for a read only cache storage associated with a
cluster. This cache will be stored as an FSx Lustre that reads from the
S3 store.}

\item{autoScalingConfiguration}{The configuration based on which FinSpace will scale in or scale out
nodes in your cluster.}

\item{clusterDescription}{A description of the cluster.}

\item{capacityConfiguration}{[required] A structure for the metadata of a cluster. It includes information about
like the CPUs needed, memory of instances, number of instances, and the
port used while establishing a connection.}

\item{releaseLabel}{[required] The version of FinSpace managed kdb to run.}

\item{vpcConfiguration}{Configuration details about the network where the Privatelink endpoint
of the cluster resides.}

\item{initializationScript}{Specifies a Q program that will be run at launch of a cluster. It is a
relative path within \emph{.zip} file that contains the custom code, which
will be loaded on the cluster. It must include the file name itself. For
example, \code{somedir/init.q}.}

\item{commandLineArguments}{Defines the key-value pairs to make them available inside the cluster.}

\item{code}{The details of the custom code that you want to use inside a cluster
when analyzing a data. It consists of the S3 source bucket, location, S3
object version, and the relative path from where the custom code is
loaded into the cluster.}

\item{executionRole}{An IAM role that defines a set of permissions associated with a cluster.
These permissions are assumed when a cluster attempts to access another
cluster.}

\item{savedownStorageConfiguration}{The size and type of the temporary storage that is used to hold data
during the savedown process. This parameter is required when you choose
\code{clusterType} as RDB. All the data written to this storage space is lost
when the cluster node is restarted.}

\item{azMode}{[required] The number of availability zones you want to assign per cluster. This
can be one of the following
\itemize{
\item \code{SINGLE} – Assigns one availability zone per cluster.
\item \code{MULTI} – Assigns all the availability zones per cluster.
}}

\item{availabilityZoneId}{The availability zone identifiers for the requested regions.}

\item{tags}{A list of key-value pairs to label the cluster. You can add up to 50
tags to a cluster.}
}
\description{
Creates a new kdb cluster.

See \url{https://www.paws-r-sdk.com/docs/finspace_create_kx_cluster/} for full documentation.
}
\keyword{internal}
